<?php


class Tac_StopHumanSpam_ControllerPublic_Forum extends XFCP_Tac_StopHumanSpam_ControllerPublic_Forum
{
	public function actionAddThread()
	{	
		$contentIsModerated = false;
		$options = XenForo_Application::get('options');	
		$input['message'] = $this->getHelper('Editor')->getMessageText('message', $this->_input);
		$input['message'] = XenForo_Helper_String::autoLinkBbCode($input['message']);
		$title = $this->_input->filterSingle('title', XenForo_Input::STRING);
		
		$perms = $this->_getSHSPermsModel()->getPermissions();				
		$stopHumanSpamModel = $this->_getStopHumanSpamModel();
		$canPost = true;
		
		$location = 'None (would have been a new thread)';
		
		if($options->ignoreExternalmages)
		{
			$input['message'] =	$stopHumanSpamModel->removeImgAndMedia($input['message']);		
		}

		// check spam titles, theads should never contain these banned words (even for users that have met like/post requiement for link-post-rules)
		if(!$perms['canBypassStopBannedWords'])
		{
			if($options->shsBannedThreadTitle && ($bWord = $stopHumanSpamModel->contentHasBannedWords($title, $options->shsBannedThreadTitleWords)))
			{
				$errorMsg = new XenForo_Phrase('shs_thread_title_contains_banned_words', array('bWord' => $bWord)); $content = $title;	
				if($options->shsModerateStopBannedWords)
				{
					$stopHumanSpamModel->logEvent('Moderated: '.$errorMsg, $input['message'], $location);
					$contentIsModerated = true;
				}
				else
				{			
					$stopHumanSpamModel->logEvent($errorMsg, $title, $location);
					return $this->responseError($errorMsg);
				}		
			}
			
			if($options->shsBannedPostContent && ($bWord = $stopHumanSpamModel->contentHasBannedWords($input['message'], $options->shsBannedPostContentWords)))
			{
				$errorMsg = new XenForo_Phrase('shs_content_contains_banned_words', array('bWord' => $bWord)); $content = $title;	
				if($options->shsModerateStopBannedWords)
				{
					$stopHumanSpamModel->logEvent('Moderated: '.$errorMsg, $input['message'], $location);
					$contentIsModerated = true;
				}
				else
				{			
					$stopHumanSpamModel->logEvent($errorMsg, $input['message'], $location);
					return $this->responseError($errorMsg);
				}
			}
		}
		

		if($options->shsPostsOn == 0)
		{		
			return $this->addThreadResponse($contentIsModerated);	
		}		
		
								
		$condFetchOpts = $stopHumanSpamModel->getcondFetchOpts($options);
		if($stopHumanSpamModel->meetsMinConditions($condFetchOpts)) 
		{	
			return $this->addThreadResponse($contentIsModerated);	
		}		
	
		
		if(!$perms['canBypassLinkPostRules'])
		{		
			if($options->shsPostsOn)
			{
				$contentHasUrl = $stopHumanSpamModel->contentHasBBUrls($input['message']); 
				$titleHasUrl = $stopHumanSpamModel->contentHasRealUrls($title); 
				if($contentHasUrl)
				{
					$content = $input['message'];
					$canPost = false;	
				}	
				if($titleHasUrl)
				{
					$content = $title;
					$canPost = false;	
				}	
			}			
			if($options->shsMailOn)
			{
				$contentHasEmail = $stopHumanSpamModel->contentHasBBEmails($input['message']); 
				$titleHasEmail = $stopHumanSpamModel->contentHasRealEmails($title);
				if($contentHasEmail)
				{
					$content = $input['message'];
					$canPost = false;	
				}
				if($titleHasEmail)
				{
					$content = $title;
					$canPost = false;	
				}
			}		
			if(!$canPost)
			{
				$replace = $stopHumanSpamModel->getMsgReplaceVars();
				$replace[] = '{nodeType}';
				$withThis = $stopHumanSpamModel->getMsgReplaceVals($condFetchOpts);
				$withThis[] = 'Forum';
				$errorMsg = str_replace($replace, $withThis,$options->shsLinksMessage);								
				$stopHumanSpamModel->logEvent($errorMsg, $content, $location);
				return $this->responseError($errorMsg);		
			}
		}
		
		// sneaky urls are okay for users that have passed meetsMinConditions (so it will never get to here)
		if(!$perms['canBypassStopSneakyUrls']  && ($options->stopSneakyUrlsPostsOn == 1))
		{
			$errorMsg = new XenForo_Phrase('a_sneaky_url_has_been_detected_in_your_content');
			if($sneakContent = $stopHumanSpamModel->contentHasSneakyUrl($input['message']))
			{	
				if($options->sneakyUrlExtraInfo)
				{	
					$errorMsg .= ": ".$sneakContent;
				}									
				$stopHumanSpamModel->logEvent($errorMsg, $input['message'], $location);
				return $this->responseError($errorMsg);	
			}
			if($sneakContent = $stopHumanSpamModel->contentHasSneakyUrl($title))
			{	
				if($options->sneakyUrlExtraInfo)
				{	
					$errorMsg .= ": ".$sneakContent;
				}						
				$stopHumanSpamModel->logEvent($errorMsg, $title, $location);
				return $this->responseError($errorMsg);	
			}
		}
		
		return $this->addThreadResponse($contentIsModerated);						
	}	

	
	
	
	
	
	public function addThreadResponse($contentIsModerated)
	{
		$responseView = parent::actionAddThread();	// at this point the content is already created
		if ($contentIsModerated && $responseView instanceof XenForo_ControllerResponse_Redirect)
	   	{
			
			$redirectTarget = ($responseView->redirectTarget);
			// this is hacky, but you can get the thread_id from redirectTarget
			// nothing else from the parent response can be used... grr
			
		
				
			$urlParts = explode('.', $url = trim(str_replace('index.php', '', $redirectTarget), '/'));
			if(count($urlParts)< 1 || !ctype_digit($urlParts['1']))
			{
				return $responseView;	
			}
			$threadId = $urlParts['1'];
			$threadIds = array($threadId);
				
			list($threads, $forums) = $this->_getInlineModThreadModel()->getThreadsAndParentData($threadIds, null);	
			$this->_getStopHumanSpamModel()->_updateThreadsDiscussionState($threads, $forums, 'moderated', 'visible');

	    			
	   	}
		return $responseView;	
		
	}	
	
	protected function _getInlineModThreadModel()
	{
		return $this->getModelFromCache('XenForo_Model_InlineMod_Thread');
	}	
			
	protected function _getStopHumanSpamModel()
	{
		return $this->getModelFromCache('Tac_StopHumanSpam_Model_StopHumanSpam');
	}

	protected function _getSHSPermsModel()
	{
		return $this->getModelFromCache('Tac_StopHumanSpam_Model_Perms');
	}	
	
	
	

}