<?php


class Tac_StopHumanSpam_ControllerPublic_Conversation extends XFCP_Tac_StopHumanSpam_ControllerPublic_Conversation
{
	public function actionInsert()
	{
		$options = XenForo_Application::get('options');	
		$input['message'] = $this->getHelper('Editor')->getMessageText('message', $this->_input);
		$input['message'] = XenForo_Helper_String::autoLinkBbCode($input['message']);
		$title = $this->_input->filterSingle('title', XenForo_Input::STRING);
		
		$perms = $this->_getSHSPermsModel()->getPermissions();				
		$stopHumanSpamModel = $this->_getStopHumanSpamModel();
		$canPost = true;
		
		$conversationId = $this->_input->filterSingle('conversation_id', XenForo_Input::UINT);
		if($conversationId)
		{
			$conversation = $this->_getConversationOrError($conversationId);
			$location = ($conversation ? XenForo_Link::buildPublicLink('conversations', $conversation):XenForo_Link::buildPublicLink('conversations'));
		}
		else
		{
			$location = XenForo_Link::buildPublicLink('conversations');
		}
		
		// check spam titles, theads should never contain these banned words (even for users that have met like/post requiement for link-post-rules)
		if(!$perms['canBypassStopBannedWords'])
		{
			if($options->shsBannedThreadTitle && ($bWord = $stopHumanSpamModel->contentHasBannedWords($title, $options->shsBannedThreadTitleWords)))
			{
				$errorMsg = new XenForo_Phrase('shs_thread_title_contains_banned_words', array('bWord' => $bWord)); $content = $title;				
				$stopHumanSpamModel->logEvent($errorMsg, $title, $location);
				return $this->responseError($errorMsg);		
			}
			
			if($options->shsBannedPostContent && ($bWord = $stopHumanSpamModel->contentHasBannedWords($input['message'], $options->shsBannedPostContentWords)))
			{
				$errorMsg = new XenForo_Phrase('shs_content_contains_banned_words', array('bWord' => $bWord)); $content = $title;				
				$stopHumanSpamModel->logEvent($errorMsg, $input['message'], $location);
				return $this->responseError($errorMsg);		
			}
		}

		if($options->shsConversationOn == 0)
		{		
			return parent::actionInsert();	
		}
		
						
		$condFetchOpts = $stopHumanSpamModel->getcondFetchOpts($options);
		if($stopHumanSpamModel->meetsMinConditions($condFetchOpts)) 
		{	
			return parent::actionInsert();	
		}		
	
		

				
		if(!$perms['canBypassLinkPostRules'])
		{		
			if($options->shsPostsOn)
			{
				$contentHasUrl = $stopHumanSpamModel->contentHasBBUrls($input['message']); 
				$titleHasUrl = $stopHumanSpamModel->contentHasRealUrls($title); 
				if($contentHasUrl)
				{
					$content = $input['message'];
					$canPost = false;	
				}	
				if($titleHasUrl)
				{
					$content = $title;
					$canPost = false;	
				}		
			}			
			if($options->shsMailOn)
			{
				$contentHasEmail = $stopHumanSpamModel->contentHasBBEmails($input['message']); 
				$titleHasEmail = $stopHumanSpamModel->contentHasRealEmails($title);
				if($contentHasEmail)
				{
					$content = $input['message'];
					$canPost = false;	
				}
				if($titleHasEmail)
				{
					$content = $title;
					$canPost = false;	
				}
			}	
			if(!$canPost)
			{
				$replace = $stopHumanSpamModel->getMsgReplaceVars();
				$replace[] = '{nodeType}';
				$withThis = $stopHumanSpamModel->getMsgReplaceVals($condFetchOpts);
				$withThis[] = 'Conversation';
				$errorMsg = str_replace($replace, $withThis,$options->shsLinksMessage);								
				$stopHumanSpamModel->logEvent($errorMsg, $content, $location);
				return $this->responseError($errorMsg);			
			}
		}
		
		// sneaky urls are okay for users that have passed meetsMinConditions (so it will never get to here)
		if(!$perms['canBypassStopSneakyUrls']  && ($options->stopSneakyUrlsConversationsOn == 1))
		{
			$errorMsg = new XenForo_Phrase('a_sneaky_url_has_been_detected_in_your_content');
			if($sneakContent = $stopHumanSpamModel->contentHasSneakyUrl($input['message']))
			{	
				if($options->sneakyUrlExtraInfo)
				{	
					$errorMsg .= ": ".$sneakContent;
				}									
				$stopHumanSpamModel->logEvent($errorMsg, $input['message'], $location);
				return $this->responseError($errorMsg);	
			}
			if($sneakContent = $stopHumanSpamModel->contentHasSneakyUrl($title))
			{	
				if($options->sneakyUrlExtraInfo)
				{	
					$errorMsg .= ": ".$sneakContent;
				}						
				$stopHumanSpamModel->logEvent($errorMsg, $title, $location);
				return $this->responseError($errorMsg);	
			}
						
		}
		
		return parent::actionInsert();		
		
		
	}
	
	public function actionSaveMessage()
	{
		$options = XenForo_Application::get('options');	
		$input['message'] = $this->getHelper('Editor')->getMessageText('message', $this->_input);
		$input['message'] = XenForo_Helper_String::autoLinkBbCode($input['message']);
		$title = $this->_input->filterSingle('title', XenForo_Input::STRING);
		
		$perms = $this->_getSHSPermsModel()->getPermissions();				
		$stopHumanSpamModel = $this->_getStopHumanSpamModel();
		$canPost = true;
		
		$conversationId = $this->_input->filterSingle('conversation_id', XenForo_Input::UINT);
		if($conversationId)
		{
			$conversation = $this->_getConversationOrError($conversationId);
			$location = ($conversation ? XenForo_Link::buildPublicLink('conversations', $conversation):XenForo_Link::buildPublicLink('conversations'));
		}
		else
		{
			$location = XenForo_Link::buildPublicLink('conversations');
		}
		
		// check spam titles, theads should never contain these banned words (even for users that have met like/post requiement for link-post-rules)
		if(!$perms['canBypassStopBannedWords'])
		{
			if($options->shsBannedThreadTitle && ($bWord = $stopHumanSpamModel->contentHasBannedWords($title, $options->shsBannedThreadTitleWords)))
			{
				$errorMsg = new XenForo_Phrase('shs_thread_title_contains_banned_words', array('bWord' => $bWord)); $content = $title;				
				$stopHumanSpamModel->logEvent($errorMsg, $title, $location);
				return $this->responseError($errorMsg);		
			}
			
			if($options->shsBannedPostContent && ($bWord = $stopHumanSpamModel->contentHasBannedWords($input['message'], $options->shsBannedPostContentWords)))
			{
				$errorMsg = new XenForo_Phrase('shs_content_contains_banned_words', array('bWord' => $bWord)); $content = $title;				
				$stopHumanSpamModel->logEvent($errorMsg, $input['message'], $location);
				return $this->responseError($errorMsg);		
			}
		}

		
		if($options->shsConversationOn == 0)
		{		
			return parent::actionSaveMessage();	
		}		
						
		$condFetchOpts = $stopHumanSpamModel->getcondFetchOpts($options);
		if($stopHumanSpamModel->meetsMinConditions($condFetchOpts)) 
		{	
			return parent::actionSaveMessage();	
		}		
	
		

				
		if(!$perms['canBypassLinkPostRules'])
		{		
			if($options->shsPostsOn)
			{
				$contentHasUrl = $stopHumanSpamModel->contentHasBBUrls($input['message']); 
				$titleHasUrl = $stopHumanSpamModel->contentHasRealUrls($title); 
				if($contentHasUrl)
				{
					$content = $input['message'];
					$canPost = false;	
				}	
				if($titleHasUrl)
				{
					$content = $title;
					$canPost = false;	
				}		
			}			
			if($options->shsMailOn)
			{
				$contentHasEmail = $stopHumanSpamModel->contentHasBBEmails($input['message']); 
				$titleHasEmail = $stopHumanSpamModel->contentHasRealEmails($title);
				if($contentHasEmail)
				{
					$content = $input['message'];
					$canPost = false;	
				}
				if($titleHasEmail)
				{
					$content = $title;
					$canPost = false;	
				}
			}	
			if(!$canPost)
			{
				$replace = $stopHumanSpamModel->getMsgReplaceVars();
				$replace[] = '{nodeType}';
				$withThis = $stopHumanSpamModel->getMsgReplaceVals($condFetchOpts);
				$withThis[] = 'Conversation';
				$errorMsg = str_replace($replace, $withThis,$options->shsLinksMessage);								
				$stopHumanSpamModel->logEvent($errorMsg, $content, $location);
				return $this->responseError($errorMsg);			
			}
		}
		
		// sneaky urls are okay for users that have passed meetsMinConditions (so it will never get to here)
		if(!$perms['canBypassStopSneakyUrls']  && ($options->stopSneakyUrlsConversationsOn == 1))
		{
			$errorMsg = new XenForo_Phrase('a_sneaky_url_has_been_detected_in_your_content');
			if($sneakContent = $stopHumanSpamModel->contentHasSneakyUrl($input['message']))
			{	
				if($options->sneakyUrlExtraInfo)
				{	
					$errorMsg .= ": ".$sneakContent;
				}									
				$stopHumanSpamModel->logEvent($errorMsg, $input['message'], $location);
				return $this->responseError($errorMsg);	
			}
			if($sneakContent = $stopHumanSpamModel->contentHasSneakyUrl($title))
			{	
				if($options->sneakyUrlExtraInfo)
				{	
					$errorMsg .= ": ".$sneakContent;
				}						
				$stopHumanSpamModel->logEvent($errorMsg, $title, $location);
				return $this->responseError($errorMsg);	
			}
		}
		
		return parent::actionSaveMessage();	
		
	}
	
	
	public function actionInsertReply()
	{
		$options = XenForo_Application::get('options');	
		$input['message'] = $this->getHelper('Editor')->getMessageText('message', $this->_input);
		$input['message'] = XenForo_Helper_String::autoLinkBbCode($input['message']);
		
		$perms = $this->_getSHSPermsModel()->getPermissions();				
		$stopHumanSpamModel = $this->_getStopHumanSpamModel();
		$canPost = true;
			
		$conversationId = $this->_input->filterSingle('conversation_id', XenForo_Input::UINT);
		if($conversationId)
		{
			$conversation = $this->_getConversationOrError($conversationId);
			$location = ($conversation ? XenForo_Link::buildPublicLink('conversations', $conversation):XenForo_Link::buildPublicLink('conversations'));
		}
		else
		{
			$location = XenForo_Link::buildPublicLink('conversations');
		}
		// check spam titles, theads should never contain these banned words (even for users that have met like/post requiement for link-post-rules)
		if(!$perms['canBypassStopBannedWords'])
		{				
			if($options->shsBannedPostContent && ($bWord = $stopHumanSpamModel->contentHasBannedWords($input['message'], $options->shsBannedPostContentWords)))
			{
				$errorMsg = new XenForo_Phrase('shs_content_contains_banned_words', array('bWord' => $bWord));			
				$stopHumanSpamModel->logEvent($errorMsg, $input['message'], $location);
				return $this->responseError($errorMsg);		
			}
		}
		

		if($options->shsConversationOn == 0)
		{		
			return parent::actionInsertReply();	
		}		
					
	
								
		$condFetchOpts = $stopHumanSpamModel->getcondFetchOpts($options);
		if($stopHumanSpamModel->meetsMinConditions($condFetchOpts)) 
		{	
			return parent::actionInsertReply();	
		}		
	
		

				
		if(!$perms['canBypassLinkPostRules'])
		{		
			if($options->shsPostsOn)
			{
				$contentHasUrl = $stopHumanSpamModel->contentHasBBUrls($input['message']); 

				if($contentHasUrl)
				{
					$content = $input['message'];
					$canPost = false;	
				}		
			}			
			if($options->shsMailOn)
			{
				$contentHasEmail = $stopHumanSpamModel->contentHasBBEmails($input['message']); 
				if($contentHasEmail)
				{
					$content = $input['message'];
					$canPost = false;	
				}
			}	
			if(!$canPost)
			{
				$replace = $stopHumanSpamModel->getMsgReplaceVars();
				$replace[] = '{nodeType}';
				$withThis = $stopHumanSpamModel->getMsgReplaceVals($condFetchOpts);
				$withThis[] = 'Conversation';
				$errorMsg = str_replace($replace, $withThis,$options->shsLinksMessage);								
				$stopHumanSpamModel->logEvent($errorMsg, $content, $location);
				return $this->responseError($errorMsg);			
			}
		}
		
		// sneaky urls are okay for users that have passed meetsMinConditions (so it will never get to here)
		if(!$perms['canBypassStopSneakyUrls'] && ($options->stopSneakyUrlsConversationsOn == 1))
		{
			$errorMsg = new XenForo_Phrase('a_sneaky_url_has_been_detected_in_your_content');
			if($sneakContent = $stopHumanSpamModel->contentHasSneakyUrl($input['message']))
			{	
				if($options->sneakyUrlExtraInfo)
				{	
					$errorMsg .= ": ".$sneakContent;
				}									
				$stopHumanSpamModel->logEvent($errorMsg, $input['message'], $location);
				return $this->responseError($errorMsg);	
			}

		}
		
		return parent::actionInsertReply();	
		
	}	
	
	


	
		
	protected function _getSHSPermsModel()
	{
		return $this->getModelFromCache('Tac_StopHumanSpam_Model_Perms');
	}	
	
		
		
	protected function _getStopHumanSpamModel()
	{
		return $this->getModelFromCache('Tac_StopHumanSpam_Model_StopHumanSpam');
	}
	
	
		
}