<?php

class Tac_StopHumanSpam_ControllerPublic_Account extends XFCP_Tac_StopHumanSpam_ControllerPublic_Account
{
	


	public function actionSignature()
	{
		
		
		if (!XenForo_Visitor::getInstance()->canEditSignature())
		{
				
			return $this->responseNoPermission();
		}
		$options = XenForo_Application::get('options');
		$perms = $this->_getSHSPermsModel()->getPermissions();	
		
		if($options->shsSigModOn == 0 || $perms['canBypassSigModRules'])
		{

			return parent::actionSignature();
		}	
		
		$stopHumanSpamModel = $this->_getStopHumanSpamModel();
	
		$condFetchOpts = $stopHumanSpamModel->getModSigCond($options);
		if ($stopHumanSpamModel->meetsMinConditions($condFetchOpts)) 
		{	
			return parent::actionSignature();	
		}

		
		return $this->_getWrapper(
			'account', 'signature',
			$this->responseView(
				'',
				'shs_can_not_modify_sig', $condFetchOpts
			)
		);
	}


	
	public function actionSignatureSave()
	{
		$this->_assertPostOnly();

		if (!XenForo_Visitor::getInstance()->canEditSignature())
		{
			return $this->actionSignatureSave();
		}
		
		$options = XenForo_Application::get('options');
		$perms = $this->_getSHSPermsModel()->getPermissions();
		
		if($options->shsSigModOn == 0 || $perms['canBypassSigModRules'])
		{
			return parent::actionSignatureSave();
		}	
		
		$stopHumanSpamModel = $this->_getStopHumanSpamModel();
	
		$condFetchOpts = $stopHumanSpamModel->getModSigCond($options);
		if ($stopHumanSpamModel->meetsMinConditions($condFetchOpts)) 
		{	
			return parent::actionSignatureSave();	
		}
	
		return $this->_getWrapper(
			'account', 'signature',
			$this->responseView(
				'XenForo_ViewPublic_Account_Signature',
				'shs_can_not_modify_sig', $condFetchOpts
			)
		);
	}
	
	
	
	
	
	public function actionPersonalDetailsSave()
	{	
			
		
		$homepage = $this->_input->filterSingle('homepage', XenForo_Input::STRING);
		
		$status = $this->_input->filterSingle('status', XenForo_Input::STRING);
		$status = XenForo_Helper_String::autoLinkBbCode($status);
		$aboutyou = $this->getHelper('Editor')->getMessageText('about', $this->_input);
		$aboutyou = XenForo_Helper_String::autoLinkBbCode($aboutyou);

		$options = XenForo_Application::get('options');
		$perms = $this->_getSHSPermsModel()->getPermissions();		
		
				
		$stopHumanSpamModel = $this->_getStopHumanSpamModel();
		$hasUrl = $stopHumanSpamModel->contentHasBBUrls($aboutyou);
		if(!$hasUrl)
		{
			$hasUrl = $stopHumanSpamModel->contentHasBBUrls($status);
		}
		$hasEmail = $stopHumanSpamModel->contentHasBBEmails($aboutyou); 
		if(!$hasEmail)
		{
			$hasEmail = $stopHumanSpamModel->contentHasBBEmails($status); 	
		}
		$canPost = true;
		
		$location = 'account/personal-details';
		
		if(!$perms['canBypassStopBannedWords'])
		{
			if($options->shsBannedThreadTitle && ($bWord = $stopHumanSpamModel->contentHasBannedWords($aboutyou, $options->shsBannedPostContentWords)))
			{
				
				$errorMsg = new XenForo_Phrase('shs_content_contains_banned_words', array('bWord' => $bWord)); 				
				$stopHumanSpamModel->logEvent($errorMsg, $aboutyou, $location);
				return $this->responseError($errorMsg);	

			}

		}
		
				
		if(
			(!$homepage || ($options->shsHomePageURLOn == 0)) && 
			( 
				(!$aboutyou || $options->shsAboutYouLinksOn == 0) && 
				((!$hasUrl || $options->shsPostsOn == 0 ) && (!$hasEmail || $options->shsMailOn == 0))  
			)
		)
		{
			return parent::actionPersonalDetailsSave();
		}	
		
		
		$condFetchOpts = $stopHumanSpamModel->getcondFetchOpts($options);
		if ($stopHumanSpamModel->meetsMinConditions($condFetchOpts)) 
		{	
			return parent::actionPersonalDetailsSave();	
		}	
	
		
		
		if(!$perms['canBypassLinkPostRules'])
		{		
			if($options->shsPostsOn)
			{
				if($hasUrl)
				{
					$content = $aboutyou;
					$canPost = false;	
				}	
			}			
			if($options->shsMailOn)
			{
				if($hasEmail)
				{
					$content = $aboutyou;
					$canPost = false;	
				}
			}	
			if($options->shsHomePageURLOn)
			{
				if($homepage)
				{
					$content = $homepage;
					$canPost = false;	
				}	
			}
			
			if(!$canPost)
			{
				$replace = $stopHumanSpamModel->getMsgReplaceVars();
				$replace[] = '{nodeType}';
				$withThis = $stopHumanSpamModel->getMsgReplaceVals($condFetchOpts);
				$withThis[] = ($homepage ? 'HomePage URL Account Setting' : 'About You Account Setting') ;
				
				$errorMsg = str_replace($replace, $withThis, $options->shsLinksMessage);						
				$stopHumanSpamModel->logEvent($errorMsg, $content, $location);
				return $this->responseError($errorMsg);		
			}
		}
		
		
		
		
		if(!$perms['canBypassStopSneakyUrls'] && ($options->stopSneakyUrlsAboutYouOn == 1))
		{
			if($sneakContent = $stopHumanSpamModel->contentHasSneakyUrl($aboutyou))
			{
				$errorMsg = new XenForo_Phrase('a_sneaky_url_has_been_detected_in_your_content');
				if($options->sneakyUrlExtraInfo)
				{	
					$errorMsg .= ": ".$sneakContent;
				}
				$stopHumanSpamModel->logEvent($errorMsg, $aboutyou, $location);
				return $this->responseError($errorMsg);
			}			
			
		}
		
		return parent::actionPersonalDetailsSave();
		

	}
	
	
	
	
	
	
	
	protected function _getSHSPermsModel()
	{
		return $this->getModelFromCache('Tac_StopHumanSpam_Model_Perms');
	}		
	

	
	protected function _getStopHumanSpamModel()
	{
		return $this->getModelFromCache('Tac_StopHumanSpam_Model_StopHumanSpam');
	}
	
}