<?php

/* 
* 
* StopProxies Model, this should be the same for all plugins. 
* However, the folling steps should be updated *1 -> *4
*/


class Tac_StopCountrySpam_Model_StopProxies extends XenForo_Model // *1 Update the class name
{

	public function stopProxiesErrors($pluginName, $input, $apiKey, $updateKeyLocation = 'register/key-update-scs', $validateIP = 1, $validateEmail = 0, $validateUsername = 0)
	{	
		// first check the local db for this IP address 
		if (!$responseError = $this->localStopProxiesResponse())
		{
			// a stopBotters report and request at the same time will be faster (don't need to wait for 2 respsonses)
			$responseError = $this->repquest($pluginName, $input, $apiKey, $updateKeyLocation, $validateIP, $validateEmail, $validateUsername);
			// add the resonse for this IP address locally so we do need to re-request if this IP address occurs with the next hour
			
			if(!$responseError)
			{
				$empty = array();
				$this->localStopProxiesSubmit($empty);	
			}
			else
			{
				$this->localStopProxiesSubmit($responseError);
			}
		}

		if($responseError == "Proxy not detected") // prevents repeated local sumbits of human attempts
		{
			return false;	
		}
		
		return $responseError;
	}	

	public function getLocalStopProxiesById($id)
	{
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM sf_stopproxies
			WHERE id = ?
		', $id);
	}
	
		
	public function localStopProxiesSubmit(array $responseErrors = array())
	{	
		$ip_address = $this-> getIp();
		
		$known_proxy = ($responseErrors ? 1 : 0);
		if(!$responseErrors)
		{
			$known_bot = 0;
		}
		else 
		{
			$known_bot = (in_array('This proxy is used by bots', $responseErrors)? 1 : 0); 
			 	
		}
	
		$sbWriter = XenForo_DataWriter::create('Tac_StopCountrySpam_DataWriter_StopProxies'); // *2 Update to use the correct DataWriter
		$sbWriter->set('ip_address', $ip_address);
		$sbWriter->set('known_bot', $known_bot);
		$sbWriter->set('known_proxy', $known_proxy);
		$sbWriter->set('time_stamp', time());
		$sbWriter->save();					
	}
	
	public function localStopProxiesResponse()
	{	
		// This is a temp cache of the StopBotters results, no need to keep querying for the same IP address if the bot attempts every few seconds
		$timeLim = time() - 300; // only get response if less than 5 minutes old (limits the query size, limits the number of requests, and bots dont often try for more than 5 mins)
		$ip_address = $this-> getIp();	
		
		$row = $this->_getDb()->fetchRow('
			SELECT *
			FROM sf_stopproxies
			WHERE ip_address = ?
			AND time_stamp > ?
		', array($ip_address, $timeLim));
		
		$errors = array();

		// we are only doing a local IP look up, so if we find a match, send the IP response back		
		if($row && $row["known_proxy"] == 1)
		{		
			$errors[] = new XenForo_Phrase('scs_stopproxies_found_the_following_param_in_their_database').' ip_address: '.$ip_address; // *3 Use your own phrase
			return $errors;
		}
		
		if($row && $row["known_proxy"] == 0)
		{
			return "Proxy not detected";
		}
		
		return false;
		
	}
	

	
	/*
	* Combines sendToStopBotters and isKnownBot, but only one request needed
	*/
	
	public function repquest($pluginName, $input = "", $apiKey, $updateKeyLocation = 'register/key-update-cic', $validateIP = 1, $validateEmail = 1, $validateUsername = 1)
	{
		
		$email_address = '';
		$username = '';
		
		if($input)
		{	
			$data = $input->filter(array(
				'username'   => XenForo_Input::STRING,
				'email'      => XenForo_Input::STRING,
			)); 
			
			
			// since we have "$input" we might be able to get username / email
			if ($login = $input->filterSingle('login', XenForo_Input::STRING))
			{
				if (Zend_Validate::is($login, 'EmailAddress'))
				{
					$email_address = $login;
				}
				else
				{
					$username = $login;
				}
			}
			
			
			
			// This will genreally be true... except when we have FBHP installed 
			// (I know...! It does unusual things you wouldn't usualy do... It's a pest.. but very effective!) 		
			if(!$username){$username = $data['username'];}
			if(!$email_address){$email_address = $data['email'];}
					
			$addOnModel = $this->getModelFromCache('XenForo_Model_AddOn');
			if (($addon = $addOnModel->getAddOnById('FoolBotHoneyPot')) && !empty($addon['active']) )
			{
				$uuids = $this->getModelFromCache('Tac_FoolBotHoneyPot_Model_HoneyPot')->getFeildUUIDs();	
				if($uuids) // no $session_id via FB reg?
				{		 
					$uuidData = $input->filter(array(
						$uuids['1']  => XenForo_Input::STRING, // 'visible to humans username'
						$uuids['2']  => XenForo_Input::STRING, // 'visible to humans email'
						));	
				
					// set username & email if visible is populated		
					// but if invisable ones have been chnaged, use them
					$username = ($data['username'] != "abaf1b4e8d0e34afa3" ? $username : $uuidData[$uuids['1']]); // 'visible to humans username'
					$email_address = 	($data['email'] != "x@819978f0-0b0f-11e2-892e-0800200c9a66.com" ? $email_address : $uuidData[$uuids['2']]); // 'visible to humans email'
				}
			}
		}
		
		$ip = $this-> getIp();	// why is it not detectng isbot in the logs
		//$ip = '94.23.199.49'; //test bot IP	
		
		$updatePath = XenForo_Link::buildPublicLink($updateKeyLocation); 
		$updateUrl = XenForo_Link::convertUriToAbsoluteUri($updatePath, true);
		
		
			
		$jsonRequest = 'http://www.stopproxies.com/repquest.php?opt=1&ip_address='.$ip.
					($username ? '&username='.rawurlencode($username) : '').
					($email_address ? '&email='.rawurlencode($email_address) : '').
					'&server_name='.rawurlencode($_SERVER['SERVER_NAME']).
					'&detection_method='.rawurlencode($pluginName).
					'&key='.$apiKey.
					'&update='.rawurlencode($updateUrl);
					
	
		try 
		{	
						
			$jsonResponse = XenForo_Application::getSession()->get('SPJsonResponse');
			if(!$jsonResponse)
			{
				$client = XenForo_Helper_Http::getClient($jsonRequest);
				$jsonResponse = $client->request('GET');
				XenForo_Application::getSession()->set('SPJsonResponse', $jsonResponse);	
			}		
			
			
			
			$json = json_decode($jsonResponse->getBody(),true);
			if($json == NULL)
			{	    		
	   	 		return false;
			}
			
			if($json)
			{

				// return errors depending on what params are found for this bot
				$errors = array();
				if(
					($json['ip_address'] == $ip) 
					)
				{
					$errors[] = new XenForo_Phrase('scs_stopproxies_found_the_following_param_in_their_database').'proxy_ip_address: '.$ip; 
				}
				if(
					($json['proxy_used_by_bots'] == '1' || $json['proxy_used_by_bots'] == 1) 
					)
				{
					$errors[] = 'This proxy is used by bots';  
				}

				
			}
		
			if($errors)
			{
				return $errors;
			}		
				
			return false;				
		}
		catch (Exception $e) 
		{		
	    	// no need to do anything, if the JSON site is down we don't want to stop registration / throw up errors to the user	
		}	
	

	}

	
	/*
	* Alow StopBotters to update the key so that requests can only be made by authorised sites
	*/
	public function updateKey($input = "", $apiKey)
	{
				
		if(!$input)
		{
			return false;
		}

		$data = $input->filter(array(
			'oldKey'   => XenForo_Input::STRING,
			'newKey'      => XenForo_Input::STRING,
		)); 
		
					
		$oldKey = $data['oldKey'];
		$newKey = $data['newKey'];

		if($oldKey != $apiKey)
		{
			return false;
		}		

		$optionId = $this->getOptionIdbyValue($apiKey);
			
		$db = $this->_getDb();
		XenForo_Db::beginTransaction($db);			
		$dw = XenForo_DataWriter::create('XenForo_DataWriter_Option');
		$dw->setExistingData($optionId);
		$dw->setOption(XenForo_DataWriter_Option::OPTION_REBUILD_CACHE, false);
		$dw->set('option_value', $newKey);
		$dw->save();
		$this->getModelFromCache('XenForo_Model_Option')->rebuildOptionCache();
		XenForo_Db::commit($db);

		return true;
	}
	
	/*
	* a dynamic way to get the OptionId for the api key (less params needed to set up stopBotters in the actionRegister)
	* The OptionId will be different for each plugin
	* This is only called if we already have the correct API key 
	*/
	
	public function getOptionIdbyValue($val) 
	{
		return $this->_getDb()->fetchRow('
			SELECT option_id
			FROM xf_option 
			WHERE option_value = ?
			AND addon_id = \'StopCountrySpam\'
		', $val);
	}

	/*
	* send back the Data array
	* Also check for dynamic uuids of FBHP	
	*/
	public function getData($input)
	{
		
		$data = $input->filter(array(
				'username'   => XenForo_Input::STRING,
				'email'      => XenForo_Input::STRING,
				'timezone'   => XenForo_Input::STRING,
				'gender'     => XenForo_Input::STRING,
				'dob_day'    => XenForo_Input::UINT,
				'dob_month'  => XenForo_Input::UINT,
				'dob_year'   => XenForo_Input::UINT,
			));
		
		$addOnModel = $this->getModelFromCache('XenForo_Model_AddOn');
		if (($addon = $addOnModel->getAddOnById('FoolBotHoneyPot')) && !empty($addon['active']) )
		{
			$uuids = $this->getModelFromCache('Tac_FoolBotHoneyPot_Model_HoneyPot')->getFeildUUIDs();			 
			$uuidData = $input->filter(array(
				$uuids['1']  => XenForo_Input::STRING, // 'visible to humans username'
				$uuids['2']  => XenForo_Input::STRING, // 'visible to humans email'
				$uuids['5']  => XenForo_Input::STRING, // 'visible timezone'
				$uuids['6']  => XenForo_Input::STRING, // 'visible gender'
			));	

			 	 
				$data['username'] 		= $uuidData[$uuids['1']]; // 'visible to humans username'
				$data['email'] 			= $uuidData[$uuids['2']]; // 'visible to humans email'
				$data['timezone'] 		= $uuidData[$uuids['5']]; // 'visible timezone'
				$data['gender'] 		= $uuidData[$uuids['6']]; // 'visible gender'
		}
	
		return $data;
			
	}
	
	
	

	public function getIp($ipAddress = null)
	{
		if ($ipAddress === null)
		{
			return (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : 0);
		}
	}

	
	
	
	public function convertIpToLong($ipAddress = null)
	{
		if ($ipAddress === null)
		{
			$ipAddress = $this->getIp();
		}

		if (is_string($ipAddress) && strpos($ipAddress, '.'))
		{
			$ipAddress = ip2long($ipAddress);
		}
		return sprintf('%u', $ipAddress);
	}



}



