<?php

class Tac_StopCountrySpam_Model_Spam extends XenForo_Model
{


	/**
	 * Gets all countries from the database
	 * @return array
	 */
	public function getAllCountries()
	{
		return $this->fetchAllKeyed('
			SELECT *
			FROM sf_stopcountryspam_iso3166_codes
			ORDER BY Country ASC
		', 'number');
	}

	




	/**
	 * Fetches an array suitable as source for admin template 'options' tag from allCountries array
	 * @return array
	 */
	public function getCountryOptionsArray(array $allCountries, $preparedOption, $fieldPrefix)
	{
		
		$selected = $preparedOption['option_value'];
		$options = array();
		foreach ($allCountries AS $countryId => $country)
		{
			$options[$countryId] = array(
				'name' => htmlspecialchars($fieldPrefix . "[$preparedOption[option_id]][".$country['a2']."]"),
				'value' => $country['a2'],
				'label' => $country['country']." - ".$country['a2'],
				'selected' => !empty($selected[$country['a2']]),
				'depth' => 0
			);
		}

		return $options;
	}


	
	
	
	public function getBlockedFromRegistering($contry2char)
	{		
		$options = XenForo_Application::get('options');		
		$selectedCountries = $options->spamCountries;
		$ListingType = ($options->blackOrWhite == 1 ? "Black" : "White");
		$countryCodeIndex = $options->countryCodeIndex;
		$isBlockedFromRegistering = false;
		
		try 
		{	
			if($ListingType == "White")
			{	
				$isBlockedFromRegistering = !in_array($contry2char , $selectedCountries); 
			}
			else 
			{
				$isBlockedFromRegistering = in_array($contry2char , $selectedCountries); 
				
			}		
		}
		catch (Exception $e) 
		{		
	    	// no need to do anything, if the JSON site is down we don't want to stop registration / throw up errors to the user	
		}
	
			
	return 	$isBlockedFromRegistering;
	
	}

	

	
	
	
	public function isProxy($pluginName, $input, array $fetchOptions = array())
	{	
		$options = XenForo_Application::get('options');	
		
		$isProxy = "";
		
		$proxy_headers = array();
		
		if($options->blockHTTP_VIA == 1) { $proxy_headers[] = 'HTTP_VIA';}
		if($options->blockHTTP_X_FORWARDED_FOR == 1){ $proxy_headers[] = 'HTTP_X_FORWARDED_FOR';}
		if($options->blockHTTP_FORWARDED_FOR == 1) { $proxy_headers[] = 'HTTP_FORWARDED_FOR';}
		if($options->blockHTTP_X_FORWARDED == 1) { $proxy_headers[] = 'HTTP_X_FORWARDED';}
		if($options->blockHTTP_FORWARDED == 1) { $proxy_headers[] = 'HTTP_FORWARDED';}
		if($options->blockHTTP_CLIENT_IP == 1) { $proxy_headers[] = 'HTTP_CLIENT_IP';}
		if($options->blockHTTP_FORWARDED_FOR_IP == 1) { $proxy_headers[] = 'HTTP_FORWARDED_FOR_IP';}
		if($options->blockVIA == 1) { $proxy_headers[] = 'VIA';}
		if($options->blockX_FORWARDED_FOR == 1) { $proxy_headers[] = 'X_FORWARDED_FOR';}
		if($options->blockFORWARDED_FOR == 1) { $proxy_headers[] = 'FORWARDED_FOR';}
		if($options->blockX_FORWARDED == 1) { $proxy_headers[] = 'X_FORWARDED';}
		if($options->blockFORWARDED == 1) { $proxy_headers[] = 'FORWARDED';}
		if($options->blockCLIENT_IP == 1) { $proxy_headers[] = 'CLIENT_IP';}		
		if($options->blockFORWARDED_FOR_IP == 1) { $proxy_headers[] = 'FORWARDED_FOR_IP';}	
		if($options->blockHTTP_PROXY_CONNECTION == 1) { $proxy_headers[] = 'HTTP_PROXY_CONNECTION';}	
		
     
		$proxyHeadersFound = "";
		
		if($proxy_headers){
			foreach($proxy_headers as $x)
			{
    			if (isset($_SERVER[$x])) {$isProxy = true; $proxyHeadersFound .=  ' $_SERVER['.$x.']: '.$_SERVER[$x];}
    		}
		}	
    	
    	if($isProxy)
    	{
	    	$isProxy .= "Proxy Headers Found: ".$proxyHeadersFound;
	    }
    	
	    
	    if( ($options->BlockRvrsDnsNotIp == 1) || ($options->BlockRvrsDnsHostIsIp == 1) ) 
	    {
			$ipAddress = long2ip($this->convertIpToLong());	
			$ReverseDNS = gethostbyaddr($ipAddress);
			$ReverseDNSIP = gethostbyname($ReverseDNS);
			
			if (($options->BlockRvrsDnsNotIp == 1) && ($ReverseDNSIP != $ipAddress)) 
			{
				$isProxy .= 'Possibly Forged IP Address, ReverseDNSIP ('.$ReverseDNSIP.') != ipAddress ('.$ipAddress.')';
			}
			
	 		if (($options->BlockRvrsDnsHostIsIp == 1) && ($ipAddress == $ReverseDNS)) 
			{
				$isProxy .= 'Possibly Forged IP Address, ipAddress ('.$ipAddress.') == ReverseDNS ('.$ReverseDNS.')';
			}
		}
		
		if ($options->scsStopProxiesEnabled == 1)
		{	
			$apiKey = $options->scsStopProxiesKey;
			$updateKeyLocation = 'register/key-update-scs';
			$stopProxiesModel = $this->getModelFromCache('Tac_StopCountrySpam_Model_StopProxies');
			$stopProxiesErrors = $stopProxiesModel->stopProxiesErrors($pluginName, $input, $apiKey, $updateKeyLocation);
			if($stopProxiesErrors)
			{
				foreach ($stopProxiesErrors as $stopProxiesError) 
				{
					$isProxy .= ' '.$stopProxiesError;	
				}
			}
		}
		
		$isProxy = ($isProxy == "" ? false : $isProxy);
		return $isProxy;
		
	}
	
	
	
	
	
	public function convertIpToLong($ipAddress = null)
	{
		if ($ipAddress === null)
		{
			$ipAddress = (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : 0);
		}

		if (is_string($ipAddress) && strpos($ipAddress, '.'))
		{
			$ipAddress = ip2long($ipAddress);
		}

		return sprintf('%u', $ipAddress);
	}

	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
}