<?php

class Tac_StopCountrySpam_Model_Log extends XenForo_Model
{
	public function getLogById($id)
	{
		return $this->_getDb()->fetchRow('
			SELECT log.*
			FROM sf_stopcountryspam_log AS log
			WHERE log.log_id = ?
		', $id);
	}

		public function getLogByEmail($email)
	{
		return $this->_getDb()->fetchRow('
			SELECT log.*
			FROM sf_stopcountryspam_log AS log
			WHERE log.email = ?
		', $email);
	}
	
		public function getLogByIP($ip)
	{
		return $this->_getDb()->fetchRow('
			SELECT log.*
			FROM sf_stopcountryspam_log AS log
			WHERE log.ip_address = ?
		', $ip);
	}
	
		public function getLogByUsername($username)
	{
		return $this->_getDb()->fetchRow('
			SELECT log.*
			FROM sf_stopcountryspam_log AS log
			WHERE log.username = ?
		', $username);
	}
	
	
	public function getLogs(array $fetchOptions = array())
	{
		$limitOptions = $this->prepareLimitFetchOptions($fetchOptions);

		return $this->fetchAllKeyed($this->limitQueryResults(
			'
				SELECT *
				FROM sf_stopcountryspam_log
				ORDER BY log_date DESC
			', $limitOptions['limit'], $limitOptions['offset']
		), ';log_id');
	}

	public function countLogs()
	{
		return $this->_getDb()->fetchOne('
			SELECT COUNT(*)
			FROM sf_stopcountryspam_log
		');
	}

	public function deleteLog($id)
	{
		$db = $this->_getDb();
		$db->delete('sf_stopcountryspam_log', 'log_id = ' . $db->quote($id));
	}

	public function clearLog()
	{
		$this->_getDb()->query('TRUNCATE TABLE sf_stopcountryspam_log');
	}

	
	public function runWeeklyCleanUp()
    {
    	// logs (no more than 3 months)
    	$log_date = (XenForo_Application::$time) - (3 * 28 * 24 * 60 * 60);
    	$this->_getDb()->fetchRow('
        	DELETE
        	FROM sf_stopcountryspam_log
        	WHERE log_date < ?
       		', $log_date);
    }



}