<?php

class Tac_StopCountrySpam_Install
{
	public static function installCode()
	{
		$db = XenForo_Application::get('db');

		$db->query("
			CREATE TABLE IF NOT EXISTS `sf_stopcountryspam_iso3166_codes` (
			  `country` varchar(250) NOT NULL,
			  `a2` varchar(2) NOT NULL,
			  `a3` varchar(3) NOT NULL,
			  `number` int(10) NOT NULL,
			  PRIMARY KEY (`number`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8;	
		");
		
		$db->query("
			CREATE TABLE IF NOT EXISTS `sf_stopcountryspam_log` (
			  `log_id` int(10) NOT NULL AUTO_INCREMENT,
			  `log_date` int(10) NOT NULL,
			  `ip_address` text NOT NULL,
			  `username` varchar(50) NOT NULL,
			  `email` varchar(120) NOT NULL,
			  `log_type` varchar(75) NOT NULL,
			  `listing_type` varchar(75) NOT NULL,
			  `request_url` text NOT NULL,
			  `request_response` text NOT NULL,
			  `country_detected` varchar(255) NOT NULL,
			  `country_code_index` varchar(255) NOT NULL,
			  `message` text NOT NULL,
			  `proxy` text NOT NULL,
			  UNIQUE KEY `log_id` (`log_id`)
			) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;
		");
			
		
		$db->query("		
			CREATE TABLE IF NOT EXISTS `sf_stopproxies` (
			  `id` int(11) NOT NULL AUTO_INCREMENT,
			  `ip_address` varchar(30) NOT NULL,
			  `known_bot` int(1) NOT NULL DEFAULT '0',
			  `known_proxy` int(1) NOT NULL DEFAULT '0',
			  `time_stamp` int(11) NOT NULL,
			  PRIMARY KEY (`id`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8;
		");	
		
		
		
		self::addColumnIfNotExist($db, "sf_stopcountryspam_log", "proxy", "text NOT NULL");
		
		self::modifyTableType($db, "sf_stopcountryspam_log", "ip_address", "varbinary(16) NOT NULL");
		// if this table already has rows, assume this is an upgrade and dont insert the default data into it
	   $isUpgrade = self::tableHasRows($db, "sf_stopcountryspam_iso3166_codes", "country");	
	   
	   if(!$isUpgrade)
		{			
			$db->query("
			   INSERT INTO `sf_stopcountryspam_iso3166_codes` (`country`, `a2`, `a3`, `number`) VALUES
				('AFGHANISTAN', 'AF', 'AFG', 4),
				('ALBANIA', 'AL', 'ALB', 8),
				('ANTARCTICA', 'AQ', 'ATA', 10),
				('ALGERIA', 'DZ', 'DZA', 12),
				('AMERICAN SAMOA', 'AS', 'ASM', 16),
				('ANDORRA', 'AD', 'AND', 20),
				('ANGOLA', 'AO', 'AGO', 24),
				('ANTIGUA AND BARBUDA', 'AG', 'ATG', 28),
				('AZERBAIJAN', 'AZ', 'AZE', 31),
				('ARGENTINA', 'AR', 'ARG', 32),
				('AUSTRALIA', 'AU', 'AUS', 36),
				('AUSTRIA', 'AT', 'AUT', 40),
				('BAHAMAS', 'BS', 'BHS', 44),
				('BAHRAIN', 'BH', 'BHR', 48),
				('BANGLADESH', 'BD', 'BGD', 50),
				('ARMENIA', 'AM', 'ARM', 51),
				('BARBADOS', 'BB', 'BRB', 52),
				('BELGIUM', 'BE', 'BEL', 56),
				('BERMUDA', 'BM', 'BMU', 60),
				('BHUTAN', 'BT', 'BTN', 64),
				('BOLIVIA', 'BO', 'BOL', 68),
				('BOSNIA AND HERZEGOWINA', 'BA', 'BIH', 70),
				('BOTSWANA', 'BW', 'BWA', 72),
				('BOUVET ISLAND', 'BV', 'BVT', 74),
				('BRAZIL', 'BR', 'BRA', 76),
				('BELIZE', 'BZ', 'BLZ', 84),
				('BRITISH INDIAN OCEAN TERRITORY', 'IO', 'IOT', 86),
				('SOLOMON ISLANDS', 'SB', 'SLB', 90),
				('VIRGIN ISLANDS (BRITISH)', 'VG', 'VGB', 92),
				('BRUNEI DARUSSALAM', 'BN', 'BRN', 96),
				('BULGARIA', 'BG', 'BGR', 100),
				('MYANMAR', 'MM', 'MMR', 104),
				('BURUNDI', 'BI', 'BDI', 108),
				('BELARUS', 'BY', 'BLR', 112),
				('CAMBODIA', 'KH', 'KHM', 116),
				('CAMEROON', 'CM', 'CMR', 120),
				('CANADA', 'CA', 'CAN', 124),
				('CAPE VERDE', 'CV', 'CPV', 132),
				('CAYMAN ISLANDS', 'KY', 'CYM', 136),
				('CENTRAL AFRICAN REPUBLIC', 'CF', 'CAF', 140),
				('SRI LANKA', 'LK', 'LKA', 144),
				('CHAD', 'TD', 'TCD', 148),
				('CHILE', 'CL', 'CHL', 152),
				('CHINA', 'CN', 'CHN', 156),
				('TAIWAN', 'TW', 'TWN', 158),
				('CHRISTMAS ISLAND', 'CX', 'CXR', 162),
				('COCOS (KEELING) ISLANDS', 'CC', 'CCK', 166),
				('COLOMBIA', 'CO', 'COL', 170),
				('COMOROS', 'KM', 'COM', 174),
				('MAYOTTE', 'YT', 'MYT', 175),
				('CONGO, Republic of', 'CG', 'COG', 178),
				('CONGO, Democratic Republic of (was Zaire)', 'CD', 'COD', 180),
				('COOK ISLANDS', 'CK', 'COK', 184),
				('COSTA RICA', 'CR', 'CRI', 188),
				('CROATIA (local name: Hrvatska)', 'HR', 'HRV', 191),
				('CUBA', 'CU', 'CUB', 192),
				('CYPRUS', 'CY', 'CYP', 196),
				('CZECH REPUBLIC', 'CZ', 'CZE', 203),
				('BENIN', 'BJ', 'BEN', 204),
				('DENMARK', 'DK', 'DNK', 208),
				('DOMINICA', 'DM', 'DMA', 212),
				('DOMINICAN REPUBLIC', 'DO', 'DOM', 214),
				('ECUADOR', 'EC', 'ECU', 218),
				('EL SALVADOR', 'SV', 'SLV', 222),
				('EQUATORIAL GUINEA', 'GQ', 'GNQ', 226),
				('ETHIOPIA', 'ET', 'ETH', 231),
				('ERITREA', 'ER', 'ERI', 232),
				('ESTONIA', 'EE', 'EST', 233),
				('FAROE ISLANDS', 'FO', 'FRO', 234),
				('FALKLAND ISLANDS (MALVINAS)', 'FK', 'FLK', 238),
				('SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS', 'GS', 'SGS', 239),
				('FIJI', 'FJ', 'FJI', 242),
				('FINLAND', 'FI', 'FIN', 246),
				('AALAND ISLANDS', 'AX', 'ALA', 248),
				('FRANCE', 'FR', 'FRA', 250),
				('FRENCH GUIANA', 'GF', 'GUF', 254),
				('FRENCH POLYNESIA', 'PF', 'PYF', 258),
				('FRENCH SOUTHERN TERRITORIES', 'TF', 'ATF', 260),
				('DJIBOUTI', 'DJ', 'DJI', 262),
				('GABON', 'GA', 'GAB', 266),
				('GEORGIA', 'GE', 'GEO', 268),
				('GAMBIA', 'GM', 'GMB', 270),
				('PALESTINIAN TERRITORY, Occupied', 'PS', 'PSE', 275),
				('GERMANY', 'DE', 'DEU', 276),
				('GHANA', 'GH', 'GHA', 288),
				('GIBRALTAR', 'GI', 'GIB', 292),
				('KIRIBATI', 'KI', 'KIR', 296),
				('GREECE', 'GR', 'GRC', 300),
				('GREENLAND', 'GL', 'GRL', 304),
				('GRENADA', 'GD', 'GRD', 308),
				('GUADELOUPE', 'GP', 'GLP', 312),
				('GUAM', 'GU', 'GUM', 316),
				('GUATEMALA', 'GT', 'GTM', 320),
				('GUINEA', 'GN', 'GIN', 324),
				('GUYANA', 'GY', 'GUY', 328),
				('HAITI', 'HT', 'HTI', 332),
				('HEARD AND MC DONALD ISLANDS', 'HM', 'HMD', 334),
				('VATICAN CITY STATE (HOLY SEE)', 'VA', 'VAT', 336),
				('HONDURAS', 'HN', 'HND', 340),
				('HONG KONG', 'HK', 'HKG', 344),
				('HUNGARY', 'HU', 'HUN', 348),
				('ICELAND', 'IS', 'ISL', 352),
				('INDIA', 'IN', 'IND', 356),
				('INDONESIA', 'ID', 'IDN', 360),
				('IRAN (ISLAMIC REPUBLIC OF)', 'IR', 'IRN', 364),
				('IRAQ', 'IQ', 'IRQ', 368),
				('IRELAND', 'IE', 'IRL', 372),
				('ISRAEL', 'IL', 'ISR', 376),
				('ITALY', 'IT', 'ITA', 380),
				('COTE D''IVOIRE', 'CI', 'CIV', 384),
				('JAMAICA', 'JM', 'JAM', 388),
				('JAPAN', 'JP', 'JPN', 392),
				('KAZAKHSTAN', 'KZ', 'KAZ', 398),
				('JORDAN', 'JO', 'JOR', 400),
				('KENYA', 'KE', 'KEN', 404),
				('KOREA, DEMOCRATIC PEOPLE''S REPUBLIC OF', 'KP', 'PRK', 408),
				('KOREA, REPUBLIC OF', 'KR', 'KOR', 410),
				('KUWAIT', 'KW', 'KWT', 414),
				('KYRGYZSTAN', 'KG', 'KGZ', 417),
				('LAO PEOPLE''S DEMOCRATIC REPUBLIC', 'LA', 'LAO', 418),
				('LEBANON', 'LB', 'LBN', 422),
				('LESOTHO', 'LS', 'LSO', 426),
				('LATVIA', 'LV', 'LVA', 428),
				('LIBERIA', 'LR', 'LBR', 430),
				('LIBYAN ARAB JAMAHIRIYA', 'LY', 'LBY', 434),
				('LIECHTENSTEIN', 'LI', 'LIE', 438),
				('LITHUANIA', 'LT', 'LTU', 440),
				('LUXEMBOURG', 'LU', 'LUX', 442),
				('MACAU', 'MO', 'MAC', 446),
				('MADAGASCAR', 'MG', 'MDG', 450),
				('MALAWI', 'MW', 'MWI', 454),
				('MALAYSIA', 'MY', 'MYS', 458),
				('MALDIVES', 'MV', 'MDV', 462),
				('MALI', 'ML', 'MLI', 466),
				('MALTA', 'MT', 'MLT', 470),
				('MARTINIQUE', 'MQ', 'MTQ', 474),
				('MAURITANIA', 'MR', 'MRT', 478),
				('MAURITIUS', 'MU', 'MUS', 480),
				('MEXICO', 'MX', 'MEX', 484),
				('MONACO', 'MC', 'MCO', 492),
				('MONGOLIA', 'MN', 'MNG', 496),
				('MOLDOVA, REPUBLIC OF', 'MD', 'MDA', 498),
				('MONTSERRAT', 'MS', 'MSR', 500),
				('MOROCCO', 'MA', 'MAR', 504),
				('MOZAMBIQUE', 'MZ', 'MOZ', 508),
				('OMAN', 'OM', 'OMN', 512),
				('NAMIBIA', 'NA', 'NAM', 516),
				('NAURU', 'NR', 'NRU', 520),
				('NEPAL', 'NP', 'NPL', 524),
				('NETHERLANDS', 'NL', 'NLD', 528),
				('NETHERLANDS ANTILLES', 'AN', 'ANT', 530),
				('ARUBA', 'AW', 'ABW', 533),
				('NEW CALEDONIA', 'NC', 'NCL', 540),
				('VANUATU', 'VU', 'VUT', 548),
				('NEW ZEALAND', 'NZ', 'NZL', 554),
				('NICARAGUA', 'NI', 'NIC', 558),
				('NIGER', 'NE', 'NER', 562),
				('NIGERIA', 'NG', 'NGA', 566),
				('NIUE', 'NU', 'NIU', 570),
				('NORFOLK ISLAND', 'NF', 'NFK', 574),
				('NORWAY', 'NO', 'NOR', 578),
				('NORTHERN MARIANA ISLANDS', 'MP', 'MNP', 580),
				('UNITED STATES MINOR OUTLYING ISLANDS', 'UM', 'UMI', 581),
				('MICRONESIA, FEDERATED STATES OF', 'FM', 'FSM', 583),
				('MARSHALL ISLANDS', 'MH', 'MHL', 584),
				('PALAU', 'PW', 'PLW', 585),
				('PAKISTAN', 'PK', 'PAK', 586),
				('PANAMA', 'PA', 'PAN', 591),
				('PAPUA NEW GUINEA', 'PG', 'PNG', 598),
				('PARAGUAY', 'PY', 'PRY', 600),
				('PERU', 'PE', 'PER', 604),
				('PHILIPPINES', 'PH', 'PHL', 608),
				('PITCAIRN', 'PN', 'PCN', 612),
				('POLAND', 'PL', 'POL', 616),
				('PORTUGAL', 'PT', 'PRT', 620),
				('GUINEA-BISSAU', 'GW', 'GNB', 624),
				('TIMOR-LESTE', 'TL', 'TLS', 626),
				('PUERTO RICO', 'PR', 'PRI', 630),
				('QATAR', 'QA', 'QAT', 634),
				('REUNION', 'RE', 'REU', 638),
				('ROMANIA', 'RO', 'ROU', 642),
				('RUSSIAN FEDERATION', 'RU', 'RUS', 643),
				('RWANDA', 'RW', 'RWA', 646),
				('SAINT HELENA', 'SH', 'SHN', 654),
				('SAINT KITTS AND NEVIS', 'KN', 'KNA', 659),
				('ANGUILLA', 'AI', 'AIA', 660),
				('SAINT LUCIA', 'LC', 'LCA', 662),
				('SAINT PIERRE AND MIQUELON', 'PM', 'SPM', 666),
				('SAINT VINCENT AND THE GRENADINES', 'VC', 'VCT', 670),
				('SAN MARINO', 'SM', 'SMR', 674),
				('SAO TOME AND PRINCIPE', 'ST', 'STP', 678),
				('SAUDI ARABIA', 'SA', 'SAU', 682),
				('SENEGAL', 'SN', 'SEN', 686),
				('SEYCHELLES', 'SC', 'SYC', 690),
				('SIERRA LEONE', 'SL', 'SLE', 694),
				('SINGAPORE', 'SG', 'SGP', 702),
				('SLOVAKIA', 'SK', 'SVK', 703),
				('VIET NAM', 'VN', 'VNM', 704),
				('SLOVENIA', 'SI', 'SVN', 705),
				('SOMALIA', 'SO', 'SOM', 706),
				('SOUTH AFRICA', 'ZA', 'ZAF', 710),
				('ZIMBABWE', 'ZW', 'ZWE', 716),
				('SPAIN', 'ES', 'ESP', 724),
				('WESTERN SAHARA', 'EH', 'ESH', 732),
				('SUDAN', 'SD', 'SDN', 736),
				('SURINAME', 'SR', 'SUR', 740),
				('SVALBARD AND JAN MAYEN ISLANDS', 'SJ', 'SJM', 744),
				('SWAZILAND', 'SZ', 'SWZ', 748),
				('SWEDEN', 'SE', 'SWE', 752),
				('SWITZERLAND', 'CH', 'CHE', 756),
				('SYRIAN ARAB REPUBLIC', 'SY', 'SYR', 760),
				('TAJIKISTAN', 'TJ', 'TJK', 762),
				('THAILAND', 'TH', 'THA', 764),
				('TOGO', 'TG', 'TGO', 768),
				('TOKELAU', 'TK', 'TKL', 772),
				('TONGA', 'TO', 'TON', 776),
				('TRINIDAD AND TOBAGO', 'TT', 'TTO', 780),
				('UNITED ARAB EMIRATES', 'AE', 'ARE', 784),
				('TUNISIA', 'TN', 'TUN', 788),
				('TURKEY', 'TR', 'TUR', 792),
				('TURKMENISTAN', 'TM', 'TKM', 795),
				('TURKS AND CAICOS ISLANDS', 'TC', 'TCA', 796),
				('TUVALU', 'TV', 'TUV', 798),
				('UGANDA', 'UG', 'UGA', 800),
				('UKRAINE', 'UA', 'UKR', 804),
				('MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF', 'MK', 'MKD', 807),
				('EGYPT', 'EG', 'EGY', 818),
				('UNITED KINGDOM', 'GB', 'GBR', 826),
				('TANZANIA, UNITED REPUBLIC OF', 'TZ', 'TZA', 834),
				('UNITED STATES', 'US', 'USA', 840),
				('VIRGIN ISLANDS (U.S.)', 'VI', 'VIR', 850),
				('BURKINA FASO', 'BF', 'BFA', 854),
				('URUGUAY', 'UY', 'URY', 858),
				('UZBEKISTAN', 'UZ', 'UZB', 860),
				('VENEZUELA', 'VE', 'VEN', 862),
				('WALLIS AND FUTUNA ISLANDS', 'WF', 'WLF', 876),
				('SAMOA', 'WS', 'WSM', 882),
				('YEMEN', 'YE', 'YEM', 887),
				('SERBIA AND MONTENEGRO', 'CS', 'SCG', 891),
				('ZAMBIA', 'ZM', 'ZMB', 894)
			");	
		}
		return true;	
	}

	
	public static function modifyTableType($db, $table, $field, $attr)
	{	
		$db->query("ALTER TABLE `".$table."` MODIFY `".$field."` ".$attr); 
	}		
	
	public static function uninstallCode()
	{
		$db = XenForo_Application::get('db');		
		// drop tables

		$db->query("
			DROP TABLE IF EXISTS
				`sf_stopcountryspam_log`, 
				`sf_stopcountryspam_iso3166_codes`
		");

		return true;
	}

	
	public static function addColumnIfNotExist($db, $table, $field, $attr)
	{
		if ($db->fetchRow('SHOW columns FROM `'.$table.'` WHERE Field = ?', $field))
		{
			return false;
		}	
		return $db->query("ALTER TABLE `".$table."` ADD `".$field."` ".$attr);
	}
	
	
	public static function tableHasRows($db, $tableName, $rowName = "node_id")
	{
		$stmt  = $db->query('SELECT COUNT('.$rowName.') AS c FROM '.$tableName.' LIMIT 1');
		$row = $stmt->fetch();
		$num_rows = $row['c'];
		if($num_rows > 0){return true;}
		return false;	
	}
	

	
	

}
