<?php

/**
* DataWriter for the ListingClaim: 
* @package XenForo_Node
*/
class Tac_StopCountrySpam_DataWriter_Log extends XenForo_DataWriter
{

	protected $_existingDataErrorPhrase = 'requested_page_not_found';
	
	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		return array(
			'sf_stopcountryspam_log' => array(	
				'log_id' => array('type' => self::TYPE_UINT, 'maxLength' => 10 ),
				'log_date' => array('type' => self::TYPE_UINT, 'required' => true, 'maxLength' => 10 ),
				//'ip_address' => array('type' => self::TYPE_UINT, 'required' => true, 'maxLength' => 20 ),
				'ip_address' => array('type' => self::TYPE_STRING),
				'log_type' => array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 75 ),
				'listing_type'  => array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 75 ),
				'username'  => array('type' => self::TYPE_STRING, 'default' => '', 'maxLength' => 50),
				'email'  => array('type' => self::TYPE_STRING, 'default' => '', 'maxLength' => 120),
				'request_url' => array('type' => self::TYPE_STRING, 'required' => true),				
				'request_response' => array('type' => self::TYPE_STRING, 'required' => true),				
				'country_detected' => array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 255),
				'country_code_index' => array('type' => self::TYPE_STRING, 'default' => '', 'maxLength' => 255),
				'message' => array('type' => self::TYPE_STRING, 'default' => ''),
				'proxy' => array('type' => self::TYPE_STRING, 'default' => ''),
			)
		);
	}

	
	


	protected function _getExistingData($data)
	{
		if (!$log_id = $this->_getExistingPrimaryKey($data, 'log_id'))
		{
			return false;
		}

		return array('sf_stopcountryspam_log' => $this->getModelFromCache('Tac_StopCountrySpam_Model_Log')->getLogById($log_id));
	}

	protected function _getUpdateCondition($tableName)	
	{
		return 'log_id = ' . $this->_db->quote($this->getExisting('log_id'));
	}


}