<?php

class Tac_StopCountrySpam_ControllerAdmin_Log extends XenForo_ControllerAdmin_Abstract
{
	protected function _preDispatch($action)
	{
		$this->assertAdminPermission('viewLogs');
	}

	public function actionLogs()
	{
		$id = $this->_input->filterSingle('id', XenForo_Input::UINT);
		if ($id)
		{
			
			
			$entry = $this->_getLogModel()->getLogById($id);
			if (!$entry)
			{
				return $this->responseError(new XenForo_Phrase('sf_requested_log_entry_not_found'), 404);
			}

			if (XenForo_Application::$versionId >= 1030000)
			{
				$entry['ip_address'] = XenForo_Helper_Ip::convertIpBinaryToString($entry['ip_address']);
			}	
			else
			{
				$entry['ip_address'] = long2ip($entry['ip_address']);
			}
			$viewParams = array(
				'entry' => $entry
			);
			return $this->responseView('XenForo_ViewAdmin_Log_ServerErrorView', 'log_stopcountryspam_view', $viewParams);
			
		}
		else
		{
			$page = $this->_input->filterSingle('page', XenForo_Input::UINT);
			$perPage = 20;
			$entries = $this->_getLogModel()->getLogs(array(
					'page' => $page,
					'perPage' => $perPage
				));
				
			foreach($entries as $key => $entry){
				if (XenForo_Application::$versionId >= 1030000)
				{		
					$entries[$key]['ip_address']= XenForo_Helper_Ip::convertIpBinaryToString($entry['ip_address']);
				}
				else
				{
					$entries[$key]['ip_address'] = long2ip($entry['ip_address']);
				}				
				
			}
			
			$viewParams = array(
				'entries' => $entries,
				'page' => $page,
				'perPage' => $perPage,
				'total' => $this->_getLogModel()->countLogs()
			);
			
			
			return $this->responseView('XenForo_ViewAdmin_Log_ServerError', 'stopcountryspam_log', $viewParams);
		}
	}

	public function actionDelete()
	{
		$id = $this->_input->filterSingle('id', XenForo_Input::UINT);
		$entry = $this->_getLogModel()->getLogById($id);
		if (!$entry)
		{
			return $this->responseError(new XenForo_Phrase('sf_requested_log_entry_not_found'), 404);
		}

		if ($this->isConfirmedPost())
		{
			$this->_getLogModel()->deleteLog($id);

			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildAdminLink('stopcountryspam/logs')
			);
		}
		else
		{
			$viewParams = array(
				'entry' => $entry
			);
			return $this->responseView('XenForo_ViewAdmin_Log_ServerErrorDelete', 'log_stopcountryspam_delete', $viewParams);
		}
	}

	public function actionClear()
	{
		if ($this->isConfirmedPost())
		{
			$this->_getLogModel()->clearLog();

			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildAdminLink('stopcountryspam/logs')
			);
		}
		else
		{
			$viewParams = array();
			return $this->responseView('XenForo_ViewAdmin_Log_ServerErrorDelete', 'stopcountryspam_log_clear', $viewParams);
		}
	}

	

	/**
	 * @return XenForo_Model_Log
	 */
	protected function _getLogModel()
	{
		return $this->getModelFromCache('Tac_StopCountrySpam_Model_Log');
	}
}