<?php

class Tac_FoolBotHoneyPot_Model_Uuids extends XenForo_Model
{
	public function getUuidsById($id)
	{
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM sf_foolbothoneypot_uuids
			WHERE id = ?
		', $id);
	}

	
	public function getUuids()
	{
		$session_id = XenForo_Application::get('session')->getSessionId();
		
		return $this->_getDb()->fetchPairs('
			SELECT number, uuid
			FROM sf_foolbothoneypot_uuids
			WHERE session_id = ?
			ORDER BY number ASC
			', $session_id);	
	}
	
	
	
	public function getUuidsByNumber($number)
	{
		$session_id = XenForo_Application::get('session')->getSessionId();
		
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM sf_foolbothoneypot_uuids
			WHERE session_id = ?
			AND number = ? 
		', array($session_id, $number));
	}
	
	
	public function setUuids()
	{
		$session_id = XenForo_Application::get('session')->getSessionId();
		
		// 1st check there are no uuids for this session id
		$uuidsData = $this->getUuids();
		
		
		
		if($session_id && (!$uuidsData)){
			$uuids = array();
			for ($i=0; $i<=71; $i++)
			{
				$rand = md5(rand()+$i);
				$randomPrefix = substr($rand, 0, 5); // to avoid colision when the same uuid is created (from same milisec)
				$uuids[] = uniqid($randomPrefix);
			}
			shuffle($uuids); 
			$time_stamp = time();
			
			
			// datawriter is too slow to write > 30 rows, validate/strip session_id
			$session_id = preg_replace("/[^a-z0-9.]+/i", "", $session_id);

			// hideous, but set this array so we can send it back without an extra query
						
			$uuidsData = array(
				1 => $uuids[1], 2 => $uuids[2], 3 => $uuids[3], 4 => $uuids[4], 5 => $uuids[5], 6 => $uuids[6], 
				11 => $uuids[11], 12 => $uuids[12], 13 => $uuids[13], 14 => $uuids[14],
				21 => $uuids[21], 22 => $uuids[22], 23 => $uuids[23], 24 => $uuids[24], 
				31 => $uuids[31], 32 => $uuids[32], 33 => $uuids[33], 34 => $uuids[34], 
				41 => $uuids[41], 42 => $uuids[42], 43 => $uuids[43], 44 => $uuids[44], 
				51 => $uuids[51], 52 => $uuids[52], 53 => $uuids[53], 54 => $uuids[54], 
				61 => $uuids[61], 62 => $uuids[62], 63 => $uuids[63], 64 => $uuids[64], 
				71 => $uuids[71], 
			);
			
			$t = XenForo_Application::$time;
			$db = XenForo_Application::get('db');		
		 	$uuidInsert = "
			INSERT INTO `sf_foolbothoneypot_uuids` (`number`, `uuid`, `explanation`, `session_id`, `time_stamp`) VALUES
				(1, '$uuids[1]', 'visible username', '$session_id', $t ),
				(2, '$uuids[2]', 'visible email', '$session_id', $t ),
				(3, '$uuids[3]', 'visible password', '$session_id', $t ),
				(4, '$uuids[4]', 'visible password_confirm', '$session_id', $t ),
				(5, '$uuids[5]', 'visible timezone', '$session_id', $t ),
				(6, '$uuids[6]', 'visible gender', '$session_id', $t ),
				(11, '$uuids[11]', 'hidden username', '$session_id', $t ),
				(12, '$uuids[12]', 'hidden username', '$session_id', $t ),
				(13, '$uuids[13]', 'hidden username', '$session_id', $t ),
				(14, '$uuids[14]', 'ajax hidden username', '$session_id', $t ),
				(21, '$uuids[21]', 'hidden email', '$session_id', $t ),
				(22, '$uuids[22]', 'hidden email', '$session_id', $t ),
				(23, '$uuids[23]', 'hidden email', '$session_id', $t ),
				(24, '$uuids[24]', 'ajax hidden email', '$session_id', $t ),
				(31, '$uuids[31]', 'hidden password', '$session_id', $t ),
				(32, '$uuids[32]', 'hidden password', '$session_id', $t ),
				(33, '$uuids[33]', 'hidden password', '$session_id', $t ),
				(34, '$uuids[34]', 'ajax hidden password', '$session_id', $t ),
				(41, '$uuids[41]', 'hidden password_confirm', '$session_id', $t ),
				(42, '$uuids[42]', 'hidden password_confirm', '$session_id', $t ),
				(43, '$uuids[43]', 'hidden password_confirm', '$session_id', $t ),
				(44, '$uuids[44]', 'ajax hidden password_confirm', '$session_id', $t ),
				(51, '$uuids[51]', 'hidden timezone', '$session_id', $t ),
				(52, '$uuids[52]', 'hidden timezone', '$session_id', $t ),
				(53, '$uuids[53]', 'hidden timezone', '$session_id', $t ),
				(54, '$uuids[54]', 'ajax hidden timezone', '$session_id', $t ),
				(61, '$uuids[61]', 'hidden gender', '$session_id', $t ),
				(62, '$uuids[62]', 'hidden gender', '$session_id', $t ),
				(63, '$uuids[63]', 'hidden gender', '$session_id', $t ),
				(64, '$uuids[64]', 'ajax hidden gender', '$session_id', $t ),
				(71, '$uuids[71]', 'javascript public uuid', '$session_id', $t )
			";	
			$db->query($uuidInsert);
			
		}
		// to reduce queries, send back the uuids (so we don't need to "get uuids again")
		return $uuidsData;
	}



}