<?php



class Tac_FoolBotHoneyPot_Model_Timer extends XenForo_Model
{

	public function getTimerById($id)
	{
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM sf_foolbothoneypot_timer 
			WHERE id = ?
		', $id);
	}
	
	
	public function getRegistrationTimer()
	{
		$session_id = XenForo_Application::get('session')->getSessionId();
		
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM sf_foolbothoneypot_timer 
			WHERE session_id = ?		
			AND time_start = (
  				select max(time_start) 
  				from sf_foolbothoneypot_timer 
  				where session_id = ?)		
		', array($session_id, $session_id));
	}
	
	public function setRegistrationTimerStart()
	{
		$timerWriter = XenForo_DataWriter::create('Tac_FoolBotHoneyPot_DataWriter_Timer');
		$timerWriter->set('time_start', time());
		$timerWriter->set('session_id', XenForo_Application::get('session')->getSessionId());
		$timerWriter->save();
	}
	
	public function deleteOldRegistrationTimer()
	{
		// delete registration times that are older than an 2 Hours (avoid daylight saving issues)
		$twoHrAgo = time()-(60*120);
		$db = $this->_getDb();
		$db->delete('sf_foolbothoneypot_timer', 'time_start < ' . $db->quote($twoHrAgo));
	}
	

	
	
	
	
}