<?php



class Tac_FoolBotHoneyPot_Model_HoneyPot extends XenForo_Model
{


	
	public function getFeildUUIDs()
	{
		$session_id = XenForo_Application::get('session')->getSessionId();
		
		return $this->_getDb()->fetchPairs('
			SELECT number, uuid
			FROM sf_foolbothoneypot_uuids
			WHERE session_id = ?
			ORDER BY number ASC
			', $session_id);	
	}
	

	public function getFbhpVersion($addon_id)
	{
		return $this->_getDb()->fetchRow('
			SELECT version_string, version_id, "xxxABC123xx" AS uuid
			FROM xf_addon
			WHERE addon_id = ?
			', $addon_id);
	}
	
	/*
	* proxy detection, uses a few methods
	* returns false if none of these methods are fruitfull
	*/
	public function isProxy(array $fetchOptions = array())
	{		
		$isProxy = false;
		
		$proxy_headers = array(   
		    'HTTP_VIA',   
		    'HTTP_X_FORWARDED_FOR',   
		    'HTTP_FORWARDED_FOR',   
		    'HTTP_X_FORWARDED',   
		    'HTTP_FORWARDED',   
		    'HTTP_CLIENT_IP',   
		    'HTTP_FORWARDED_FOR_IP',   
		    'VIA',   
		    'X_FORWARDED_FOR',   
		    'FORWARDED_FOR',   
		    'X_FORWARDED',   
		    'FORWARDED',   
		    'CLIENT_IP',   
		    'FORWARDED_FOR_IP',   
		    'HTTP_PROXY_CONNECTION'   
		     );
	     
		$proxyHeadersFound = "";
		foreach($proxy_headers as $x)
		{
    		if (isset($_SERVER[$x])) {$isProxy = true; $proxyHeadersFound .=  ' $_SERVER['.$x.']: '.$_SERVER[$x];}
    	}
			
    	if($isProxy)
    	{
	    	return "Proxy Headers Found: ".$proxyHeadersFound;
	    }
    	
		$ipAddress = long2ip($this->convertIpToLong());	
		$ReverseDNS = gethostbyaddr($ipAddress);
		$ReverseDNSIP = gethostbyname($ReverseDNS);
		
		if ($ReverseDNSIP != $ipAddress) 
		{
			return 'Possibly Forged IP Address, ReverseDNSIP ('.$ReverseDNSIP.') != ipAddress ('.$ipAddress.')';
		}
		
 		if ($ipAddress == $ReverseDNS) 
		{
			return 'Possibly Forged IP Address, ipAddress ('.$ipAddress.') == ReverseDNS ('.$ReverseDNS.')';
		}
		
		else 
		{
			return false;
		}
	}
	
	
	
	/**
	 * Gets all of the Hidden Fields that have been altered
	 * A normal user will not change the hidden fields, but a bot usualy will 
	 * Returns false if no hidden fields are changed (human)
	 *
	 * @param array $hiddenFields
	 *
	 * @return array|false
	 */
	
	public function getAlteredHiddenFields($hiddenFields){	
		
		
		// Current Expected Hidden Fields: 
		$expected = array ( 
				'username'				=> 'abaf1b4e8d0e34afa3', // hidden username 
				'email'					=> 'x@819978f0-0b0f-11e2-892e-0800200c9a66.com', // hidden email
				'timezone'				=> 'Pacific/Midway', // hidden timezone
				'gender'				=> 'male', // hidden gender 
				'password'     			=> 'xxxxxx', // hidden password
				'password_confirm'     	=> 'xxxxxx', // hidden password_confirm
				
				'uuid11'				=> '', // hidden username
				'uuid21'				=> '', // hidden email
				'uuid51'				=> 'Pacific/Midway', // hidden timezone 
				'uuid61'				=> '', // hidden gender 
				'uuid31'     			=> '', // hidden password
				'uuid41'     			=> '', // hidden password_confirm
				 
				'uuid12'				=> '', // hidden username
				'uuid22'				=> '', // hidden email
				'uuid52'				=> 'Pacific/Midway', // hidden timezone 
				'uuid62'				=> '', // hidden gender 
				'uuid32'     			=> '', // hidden password
				'uuid42'     			=> '', // hidden password_confirm
				
				'uuid13'				=> '', // hidden username
				'uuid23'				=> '', // hidden email
				'uuid53'				=> 'Pacific/Midway', // hidden timezone 
				'uuid63'				=> '', // hidden gender 
				'uuid33'     			=> '', // hidden password
				'uuid43'     			=> '', // hidden password_confirm				
						
								
			);
		//var_dump($hiddenFields);	
		// there could be a problem if a user has previously registerd a similar form and the browser (chrome) autofills the standard username/email/password/'password_confirm' fields 
		// so for the standard ones, I need to set autocomplete="off" and to be sure, set the values to "x" since a value shouldn't ever be overwirtten by autocomplete, and gender to "male"
		// (I wont need to do this for the hidden uuid named fields)
		$diff = array_diff($hiddenFields, $expected);	
			
		if(empty($diff))
		{
			return false;		
		}
			
	
		return array_diff($hiddenFields, $expected);
		
	
	}
	
	
	
	
	
	
	
	public function convertIpToLong($ipAddress = null)
	{
		if ($ipAddress === null)
		{
			$ipAddress = (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : 0);
		}

		if (is_string($ipAddress) && strpos($ipAddress, '.'))
		{
			$ipAddress = ip2long($ipAddress);
		}

		return sprintf('%u', $ipAddress);
	}

	
	
	

	public function postRequest($url, $postdata, $files = null)
	{
	    $data = "";
	    $boundary = "---------------------".substr(md5(rand(0,32000)), 0, 10);
	      
	    //Collect Postdata
	    foreach($postdata as $key => $val)
	    {
	        $data .= "--$boundary\n";
	        $data .= "Content-Disposition: form-data; name=\"".$key."\"\n\n".$val."\n";
	    }
	    
	    $data .= "--$boundary\n";
	   
	    //Collect Filedata
	    if($files)
	    {
		    foreach($files as $key => $file)
	    	{
		        $fileContents = file_get_contents($file['tmp_name']);	       
		        $data .= "Content-Disposition: form-data; name=\"{$key}\"; filename=\"{$file['name']}\"\n";
		        $data .= "Content-Type: image/jpeg\n";
		        $data .= "Content-Transfer-Encoding: binary\n\n";
		        $data .= $fileContents."\n";
		        $data .= "--$boundary--\n";
	    	}
    	}
	 
	    $params = array('http' => array(
	           'method' => 'POST',
	           'header' => 	'Content-Type: multipart/form-data; boundary='.$boundary, 
	           'content' => $data
	           
	        ));
	
	   $ctx = stream_context_create($params);
	   $fp = fopen($url, 'rb', false, $ctx);
	  
	   if (!$fp) {throw new Exception("Problem with $url, $php_errormsg");}
	   $response = @stream_get_contents($fp);
	   if ($response === false) {throw new Exception("Problem reading data from $url, $php_errormsg");}
	   return $response;
	}


	
	public function runWeeklyCleanUp()
	{
		
		$time_stamp = (XenForo_Application::$time) - (2 * 60 * 60); // delete everything apart from uuids in the last 2 hours (avoids daylight saving issues)
		
		// uuids	
		$this->_getDb()->fetchRow('
			DELETE 
			FROM sf_foolbothoneypot_uuids
			WHERE time_stamp < ?
			', $time_stamp);
		
		// logs (no more than 3 months)
		$log_date = (XenForo_Application::$time) - (3 * 28 * 24 * 60 * 60);
		$this->_getDb()->fetchRow('
			DELETE 
			FROM sf_foolbothoneypot_log
			WHERE log_date < ?
			', $log_date);
		
		
	}	
	
	
	
}