<?php

/**
* DataWriter for the ListingClaim: 
* @package XenForo_Node
*/
class Tac_FoolBotHoneyPot_DataWriter_Uuids extends XenForo_DataWriter
{

	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		return array(
			'sf_foolbothoneypot_uuids' => array(	
				'id'        	  		=> array('type' => self::TYPE_UINT, 'autoIncrement' => true, 'maxLength' => 11),
				'number' 				=> array('type' => self::TYPE_UINT, 'required' => true, 'maxLength' => 11),
				'uuid' 					=> array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 18),
				'explanation' 			=> array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 120),
				'session_id' 			=> array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 60),
				'time_stamp' 			=> array('type' => self::TYPE_UINT, 'required' => true, 'maxLength' => 11),
				
			)
		);
	}

	
	


	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data, 'id'))
		{
			return false;
		}

		return array('sf_foolbothoneypot_uuids' => $this->getModelFromCache('Tac_FoolBotHoneyPot_Model_Uudis')->getUuidsById($id));
	}

	protected function _getUpdateCondition($tableName)	
	{
		return 'id = ' . $this->_db->quote($this->getExisting('id'));
	}


}