<?php

/**
* Data writer for users.
*
* @package XenForo_User
*/
class Tac_FoolBotHoneyPot_DataWriter_User extends XenForo_DataWriter_User
{
	
	protected function _getFields()
	{
		$userArray = parent::_getFields();
		$uuids = $this->_getHoneyPotModel()->getFeildUUIDs();
		
		// if there are no uuids for this session, then it's quite likely that this is coming from FB registration, 
		// in which case, dont merge, just use parent
		if (!$uuids){return $userArray;}
		if ($uuids)
		{		
			$uuidArray = array(
				$uuids['1'] // username, _verifyUsername knows to expect a field "username" so we need a similar function that uses the uuid fieldname : _verifyUuid1 => _verifyUsernameUuid
					=> array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 50, 'verification' => array('$this', '_verifyUuid1'), 'requiredError' => 'please_enter_valid_name'),
				$uuids['2'] // email
					=> array('type' => self::TYPE_STRING, 'maxLength' => 120, 'verification' => array('$this', '_verifyUuid2'), 'requiredError' => 'please_enter_valid_email'),
				$uuids['5'] // timezone
						=> array('type' => self::TYPE_STRING, 'default' => 'Europe/London', 'maxLength' => 50, 'verification' => array('$this', '_verifyUuid5')),				
				$uuids['6'] // gender
						=> array('type' => self::TYPE_STRING, 'default' => '', 'allowedValues' => array('male', 'female', '')),	
						
				$uuids['11'] // username, _verifyUsername knows to expect a field "username" so we need a similar function => _verifyUuid1
					=> array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 50, 'verification' => array('$this', '_verifyUuid11'), 'requiredError' => 'please_enter_valid_name'),
				$uuids['12'] // username, _verifyUsername knows to expect a field "username" so we need a similar function => _verifyUuid1
					=> array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 50, 'verification' => array('$this', '_verifyUuid12'), 'requiredError' => 'please_enter_valid_name'),	
				$uuids['13'] // username, _verifyUsername knows to expect a field "username" so we need a similar function => _verifyUuid1
					=> array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 50, 'verification' => array('$this', '_verifyUuid13'), 'requiredError' => 'please_enter_valid_name'),	
					
				$uuids['21'] // email
					=> array('type' => self::TYPE_STRING, 'maxLength' => 120, 'verification' => array('$this', '_verifyUuid21'), 'requiredError' => 'please_enter_valid_email'),				
				$uuids['22'] // email
					=> array('type' => self::TYPE_STRING, 'maxLength' => 120, 'verification' => array('$this', '_verifyUuid22'), 'requiredError' => 'please_enter_valid_email'),		
				$uuids['23'] // email
					=> array('type' => self::TYPE_STRING, 'maxLength' => 120, 'verification' => array('$this', '_verifyUuid23'), 'requiredError' => 'please_enter_valid_email'),		
					
				$uuids['51'] // timezone
						=> array('type' => self::TYPE_STRING, 'default' => 'Europe/London', 'maxLength' => 50, 'verification' => array('$this', '_verifyUuid51')),	
				$uuids['52'] // timezone
						=> array('type' => self::TYPE_STRING, 'default' => 'Europe/London', 'maxLength' => 50, 'verification' => array('$this', '_verifyUuid52')),
				$uuids['53'] // timezone
						=> array('type' => self::TYPE_STRING, 'default' => 'Europe/London', 'maxLength' => 50, 'verification' => array('$this', '_verifyUuid53')),	
						
				$uuids['61'] // gender
						=> array('type' => self::TYPE_STRING, 'default' => '', 'allowedValues' => array('male', 'female', '')),	
				$uuids['62'] // gender
						=> array('type' => self::TYPE_STRING, 'default' => '', 'allowedValues' => array('male', 'female', '')),	
				$uuids['63'] // gender
						=> array('type' => self::TYPE_STRING, 'default' => '', 'allowedValues' => array('male', 'female', '')),					
											
				);
			
					
			$userArray['xf_user'] = (array_merge($uuidArray, $userArray['xf_user']));	
			return  array_merge($uuidArray, $userArray);
		}
		
		
	}
	
	
	

	
		
	/**
	*
	* new validation so that uuid can be used instead of "username" (in this case, for now it's just uuid1)
	*
	* Verification callback to check that a username is valid 
	*
	* @param string Username
	*
	* @return bool
	*/
	protected function _verifyUsernameUuid(&$username, $indx) // like _verifyUsername
	{
		if ($this->isUpdate() && $username === $this->getExisting('username'))
		{
			return true; // unchanged, always pass
		}
		
		// standardize white space in names
		$username = trim(preg_replace('/\s+/', ' ', $username));

		$usernameLength = utf8_strlen($username);
		$minLength = $this->getOption(self::OPTION_USERNAME_LENGTH_MIN);
		$maxLength = $this->getOption(self::OPTION_USERNAME_LENGTH_MAX);

		$uuids = $this->_getHoneyPotModel()->getFeildUUIDs();
		
		if (!$this->getOption(self::OPTION_ADMIN_EDIT))
		{
			if ($minLength > 0 && $usernameLength < $minLength)
			{
				$this->error(new XenForo_Phrase('please_enter_name_that_is_at_least_x_characters_long', array('count' => $minLength)), $uuids[$indx]);
				return false;
			}
			if ($maxLength > 0 && $usernameLength > $maxLength)
			{
				$this->error(new XenForo_Phrase('please_enter_name_that_is_at_most_x_characters_long', array('count' => $maxLength)), $uuids[$indx]);
				return false;
			}

			$disallowedNames = $this->getOption(self::OPTION_USERNAME_DISALLOWED_NAMES);
			if ($disallowedNames)
			{
				foreach ($disallowedNames AS $name)
				{
					$name = trim($name);
					if ($name === '')
					{
						continue;
					}
					if (stripos($username, $name) !== false)
					{
						$this->error(new XenForo_Phrase('please_enter_another_name_disallowed_words'), $uuids[$indx]);
						return false;
					}
				}
			}

			$matchRegex = $this->getOption(self::OPTION_USERNAME_REGEX);
			if ($matchRegex)
			{
				$matchRegex = str_replace('#', '\\#', $matchRegex); // escape delim only
				if (!preg_match('#' . $matchRegex . '#i', $username))
				{
					$this->error(new XenForo_Phrase('please_enter_another_name_required_format'), $uuids[$indx]);
					return false;
				}
			}

			$censoredUserName = XenForo_Helper_String::censorString($username);
			if ($censoredUserName !== $username)
			{
				$this->error(new XenForo_Phrase('please_enter_name_that_does_not_contain_any_censored_words'), $uuids[$indx]);
				return false;
			}
		}

		// ignore check if unicode properties aren't compiled
		try
		{
			if (@preg_match("/\p{C}/u", $username))
			{
				$this->error(new XenForo_Phrase('please_enter_name_without_using_control_characters'), $uuids[$indx]);
				return false;
			}
		}
		catch (Exception $e) {}

		if (strpos($username, ',') !== false)
		{
			$this->error(new XenForo_Phrase('please_enter_name_that_does_not_contain_comma'), $uuids[$indx]);
			return false;
		}

		if (Zend_Validate::is($username, 'EmailAddress'))
		{
			$this->error(new XenForo_Phrase('please_enter_name_that_does_not_resemble_an_email_address'), $uuids[$indx]);
			return false;
		}

		$existingUser = $this->_getUserModel()->getUserByName($username);
		if ($existingUser && $existingUser['user_id'] != $this->get('user_id'))
		{
			$this->error(new XenForo_Phrase('usernames_must_be_unique'), $uuids[$indx]);
			return false;
		}

		// compare against romanized name to help reduce confusable issues
		$romanized = utf8_deaccent(utf8_romanize($username));
		if ($romanized != $username)
		{
			$existingUser = $this->_getUserModel()->getUserByName($romanized);
			if ($existingUser && $existingUser['user_id'] != $this->get('user_id'))
			{
				$this->error(new XenForo_Phrase('usernames_must_be_unique'), $uuids[$indx]);
				return false;
			}
		}

		return true;
	}
	
	
	
	
	
	
	
	/**
	* Verification callback to check the email address is in a valid form
	*
	* @param string Email Address
	*
	* @return bool
	*/
	protected function _verifyEmailUuid(&$email, $indx)  // like _verifyEmail
	{
		if ($this->isUpdate() && $email === $this->getExisting('email'))
		{
			return true;
		}

		if ($this->getOption(self::OPTION_ADMIN_EDIT) && $email === '')
		{
			return true;
		}

		$uuids = $this->_getHoneyPotModel()->getFeildUUIDs();
		
		if (!Zend_Validate::is($email, 'EmailAddress'))
		{
			$this->error(new XenForo_Phrase('please_enter_valid_email'), $uuids[$indx]);
			return false;
		}

		$existingUser = $this->_getUserModel()->getUserByEmail($email);
		if ($existingUser && $existingUser['user_id'] != $this->get('user_id'))
		{
			$this->error(new XenForo_Phrase('email_addresses_must_be_unique'), $uuids[$indx]);
			return false;
		}

		if (XenForo_Helper_Email::isEmailBanned($email))
		{
			$this->error(new XenForo_Phrase('email_address_you_entered_has_been_banned_by_administrator'), $uuids[$indx]);
			return false;
		}

		return true;
	}
	
	
	
	
	
	protected function _verifyTimezoneUuid(&$timezone, $indx)  // like _verifyTimezone
	{
		try
		{
			new DateTimeZone($timezone);
		}
		catch (Exception $e)
		{
			$uuids = $this->_getHoneyPotModel()->getFeildUUIDs();
			$this->error(new XenForo_Phrase('please_select_valid_time_zone'), $uuids[$indx]);
			return false;
		}

		return true;
	}
	
	
	
	
	protected function _verifyUuid1(&$username) {$this->_verifyUsernameUuid($username, '1');}
	protected function _verifyUuid11(&$username){$this->_verifyUsernameUuid($username, '11');}
	protected function _verifyUuid12(&$username){$this->_verifyUsernameUuid($username, '12');}
	protected function _verifyUuid13(&$username){$this->_verifyUsernameUuid($username, '13');}	

	protected function _verifyUuid2(&$email) {$this->_verifyEmailUuid($email, '2');}
	protected function _verifyUuid21(&$email){$this->_verifyEmailUuid($email, '21');}
	protected function _verifyUuid22(&$email){$this->_verifyEmailUuid($email, '22');}
	protected function _verifyUuid23(&$email){$this->_verifyEmailUuid($email, '23');}	
	
	protected function _verifyUuid5(&$timezone) {$this->_verifyTimezoneUuid($timezone, '5');}
	protected function _verifyUuid51(&$timezone){$this->_verifyTimezoneUuid($timezone, '51');}
	protected function _verifyUuid52(&$timezone){$this->_verifyTimezoneUuid($timezone, '52');}
	protected function _verifyUuid53(&$timezone){$this->_verifyTimezoneUuid($timezone, '53');}
	
	protected function _getHoneyPotModel()
	{
		return $this->getModelFromCache('Tac_FoolBotHoneyPot_Model_HoneyPot');
	}	
	
	
	
	
}
