<?php

/**
* DataWriter for the ListingClaim: 
* @package XenForo_Node
*/
class Tac_FoolBotHoneyPot_DataWriter_Timer extends XenForo_DataWriter
{

	protected $_existingDataErrorPhrase = 'requested_page_not_found';
	
	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		return array(
			'sf_foolbothoneypot_timer' => array(	
				'id'        	  	=> array('type' => self::TYPE_UINT, 'autoIncrement' => true, 'maxLength' => 10),
				'time_start' 		=> array('type' => self::TYPE_UINT, 'required' => true, 'maxLength' => 11),
				'session_id' 		=> array('type' => self::TYPE_STRING, 'required' => true)
			)
		);
	}

	
	


	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data, 'id'))
		{
			return false;
		}

		return array('sf_foolbothoneypot_timer' => $this->getModelFromCache('Tac_FoolBotHoneyPot_Model_Timer')->getTimerById($id));
	}

	protected function _getUpdateCondition($tableName)	
	{
		return 'id = ' . $this->_db->quote($this->getExisting('id'));
	}


}