<?php

class Tac_FoolBotHoneyPot_DataWriter_StopBotters extends XenForo_DataWriter
{

	
	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		return array(
			'sf_stopbotters' => array(	
				'id'        	  			=> array('type' => self::TYPE_UINT,   	'autoIncrement' => true, 	'maxLength' => 11),
				'ip_address' 				=> array('type' => self::TYPE_STRING,   'default' => '0', 			'maxLength' => 30),
				'known_bot' 				=> array('type' => self::TYPE_UINT, 	'default' => 0, 			'maxLength' => 1),
				'time_stamp'  				=> array('type' => self::TYPE_UINT, 	'default' => 0, 			'maxLength' => 11)
			)
		);
	}

	
	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data, 'id'))
		{
			return false;
		}

		return array('sf_stopbotters' => $this->getModelFromCache('Tac_FoolBotHoneyPot_Model_StopBotters')->getLocalStopBottersById($id));
	}

	protected function _getUpdateCondition($tableName)	
	{
		return 'id = ' . $this->_db->quote($this->getExisting('id'));
	}


}