<?php

/**
* DataWriter for the ListingClaim: 
* @package XenForo_Node
*/
class Tac_FoolBotHoneyPot_DataWriter_Log extends XenForo_DataWriter
{


	protected function _getFields()
	{
		return array(
			'sf_foolbothoneypot_log' => array(	
				'log_id'        	  		=> array('type' => self::TYPE_UINT,   'autoIncrement' => true, 	'maxLength' => 10 ),
				'log_date' 					=> array('type' => self::TYPE_UINT,   'default' => 1, 'maxLength' => 10 ),
				'ip_address' 				=> array('type' => self::TYPE_STRING),
				'username'  				=> array('type' => self::TYPE_STRING, 'default' => '', 'maxLength' => 50),
				'email'  					=> array('type' => self::TYPE_STRING, 'default' => '', 'maxLength' => 120),
				'log_type' 					=> array('type' => self::TYPE_STRING, 'default' => '', 'maxLength' => 255 ),
				'altered_hidden_fields'  	=> array('type' => self::TYPE_STRING, 'default' => ''),
				'registration_errors'  		=> array('type' => self::TYPE_STRING, 'default' => ''),
				'message' 					=> array('type' => self::TYPE_STRING, 'default' => ''),
				'user_agent' 				=> array('type' => self::TYPE_STRING, 'default' => ''),
				'port' 						=> array('type' => self::TYPE_STRING, 'default' => ''),
				'server' 					=> array('type' => self::TYPE_STRING, 'default' => ''),	
				'registration_time'			=> array('type' => self::TYPE_UINT,   'default' => 0, 'maxLength' => 10),
				'is_proxy'					=> array('type' => self::TYPE_STRING, 'default' => 'No Proxy Detected'),	
				'browser_plugins_detected'	=> array('type' => self::TYPE_STRING, 'required' => false, 'default' => ''),
				'javascript_enabled' 		=> array('type' => self::TYPE_UINT,   'required' => false, 'default' => 0, 'maxLength' => 1 ),
				'found_on_stopbotters' 		=> array('type' => self::TYPE_UINT,   'required' => false, 'default' => 0, 'maxLength' => 1 ),
				'is_spam_api1' 				=> array('type' => self::TYPE_UINT,   'required' => false, 'default' => 0, 'maxLength' => 1 ),
				'is_spam_api2' 				=> array('type' => self::TYPE_UINT,   'required' => false, 'default' => 0, 'maxLength' => 1 ),
				'is_spam_api3' 				=> array('type' => self::TYPE_UINT,   'required' => false, 'default' => 0, 'maxLength' => 1 ),
				'is_spam_api4' 				=> array('type' => self::TYPE_UINT,   'required' => false, 'default' => 0, 'maxLength' => 1 ),
				'is_spam_api5' 				=> array('type' => self::TYPE_UINT,   'required' => false, 'default' => 0, 'maxLength' => 1 ),
				'is_spam_api6' 				=> array('type' => self::TYPE_UINT,   'required' => false, 'default' => 0, 'maxLength' => 1 ),
				'is_spam_api7' 				=> array('type' => self::TYPE_UINT,   'required' => false, 'default' => 0, 'maxLength' => 1 ),
				'is_spam_api8' 				=> array('type' => self::TYPE_UINT,   'required' => false, 'default' => 0, 'maxLength' => 1 ),
				'is_spam_api9' 				=> array('type' => self::TYPE_UINT,   'required' => false, 'default' => 0, 'maxLength' => 1 ),
				'is_spam_api10' 			=> array('type' => self::TYPE_UINT,   'required' => false, 'default' => 0, 'maxLength' => 1 ),
			)
		);
	}

	
	


	protected function _getExistingData($data)
	{
		if (!$log_id = $this->_getExistingPrimaryKey($data, 'log_id'))
		{
			return false;
		}

		return array('sf_foolbothoneypot_log' => $this->getModelFromCache('Tac_FoolBotHoneyPot_Model_Log')->getLogById($log_id));
	}

	protected function _getUpdateCondition($tableName)	
	{
		return 'log_id = ' . $this->_db->quote($this->getExisting('log_id'));
	}


}