<?php

/**
* DataWriter for the ListingClaim: 
* @package XenForo_Node
*/
class Tac_FoolBotHoneyPot_DataWriter_ClientSide extends XenForo_DataWriter
{


	protected function _getFields()
	{
		return array(
			'sf_foolbothoneypot_clientside_detection' => array(	
				'id'        	  			=> array('type' => self::TYPE_UINT, 'autoIncrement' => true, 'maxLength' => 10),
				'session_id' 				=> array('type' => self::TYPE_STRING, 'required' => true),
				'javascript_on' 			=> array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 1),
				'detected_plugins' 			=> array('type' => self::TYPE_STRING, 'required' => false, 'default' => ''),	
				'mouse_click_count' 		=> array('type' => self::TYPE_UINT, 'required' => false, 'default' => 0, 'maxLength' => 6),
				'key_press_count' 			=> array('type' => self::TYPE_UINT, 'required' => false, 'default' => 0, 'maxLength' => 6),
				'screen_touch_count' 		=> array('type' => self::TYPE_UINT, 'required' => false, 'default' => 0, 'maxLength' => 6),
				'key_click_touch_pattern' 	=> array('type' => self::TYPE_STRING, 'required' => false, 'default' => ''),				
				'time_stamp' 				=> array('type' => self::TYPE_UINT, 'required' => true, 'maxLength' => 11),
				'updated' 					=> array('type' => self::TYPE_UINT, 'required' => true, 'maxLength' => 1),
				'uuid' 						=> array('type' => self::TYPE_STRING, 'required' => false, 'default' => '', 'maxLength' => 32),
				'correct_uuid'				=> array('type' => self::TYPE_UINT, 'required' => false, 'default' => 0, 'maxLength' => 1),
			)
		);
	}

	
	


	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data, 'id'))
		{
			return false;
		}

		return array('sf_foolbothoneypot_clientside_detection' => $this->getModelFromCache('Tac_FoolBotHoneyPot_Model_ClientSide')->getClientSideById($id));
	}

	protected function _getUpdateCondition($tableName)	
	{
		return 'id = ' . $this->_db->quote($this->getExisting('id'));
	}


}