<?php

class Tac_FoolBotHoneyPot_ControllerAdmin_Log extends XenForo_ControllerAdmin_Abstract
{
	protected function _preDispatch($action)
	{
		$this->assertAdminPermission('viewLogs');
	}

	public function actionLogs()
	{
		$id = $this->_input->filterSingle('id', XenForo_Input::UINT);
		$options = XenForo_Application::get('options');
		if ($id)
		{
			
			
			$entry = $this->_getLogModel()->getLogById($id);
			if (!$entry)
			{
				return $this->responseError(new XenForo_Phrase('sf_requested_log_entry_not_found'), 404);
			}

		
			if (XenForo_Application::$versionId >= 1030000)
			{
				$entry['ip_address'] = XenForo_Helper_Ip::convertIpBinaryToString($entry['ip_address']);
			}	
			else
			{
				$entry['ip_address'] = long2ip($entry['ip_address']);
			}	
			$altered_hFields 	= unserialize($entry['altered_hidden_fields']);
			$rErrors = unserialize($entry['registration_errors']);
			$svr = unserialize($entry['server']);
			
			if($svr){
				foreach ($svr as $key => $sv)
				{
					if(is_array($sv))
					{
						$svr[$key] = serialize($svr[$key]);	
					}
						
				}
			}

			
			
			$viewParams = array(
				'entry' => $entry,
				'altered_hFields' =>$altered_hFields,
				'rErrors' =>$rErrors,
				'svr' =>$svr,
			);
			
			
			return $this->responseView('XenForo_ViewAdmin_Log_ServerErrorView', 'log_foolbothoneypot_view', $viewParams);
			
		}
		else
		{
			$username = $this->_input->filterSingle('username', XenForo_Input::STRING);	
			$email = $this->_input->filterSingle('email', XenForo_Input::STRING);	
			$filter = $this->_input->filterSingle('filter', XenForo_Input::STRING);	
			
			$page = $this->_input->filterSingle('page', XenForo_Input::UINT);
			$perPage = 20;
			$entries = $this->_getLogModel()->getLogs(array(
					'page' => $page,
					'perPage' => $perPage,
					'username' => $username,
					'email' => $email,
					'filter' => $filter,
				));

				
			$activeApis = array();
			$addOnModel = $this->getModelFromCache('XenForo_Model_AddOn');
			if (($addon = $addOnModel->getAddOnById('anyApi')) && !empty($addon['active']) )
			{	
				$allApiStngs = $this->getModelFromCache('Tac_AnyApi_Model_ApiSettings')->getApiSettings();	
				foreach($allApiStngs as $key => $apiSettings)
				{
					if( ($apiSettings['api_active'] == 1) && ($apiSettings['url'] != "") && ($apiSettings['logic_set'] != "") ) 
					{
						$activeApis[] = $apiSettings;
					}
				}	
			}
			
								
			foreach($entries as $key => $entry)
			{
				
				if (XenForo_Application::$versionId >= 1030000)
				{		
					$entries[$key]['ip_address']= XenForo_Helper_Ip::convertIpBinaryToString($entry['ip_address']);
				}
				else
				{
					$entries[$key]['ip_address'] = long2ip($entry['ip_address']);
				}
				$entries[$key]['altered_hidden_count'] = ($entry['altered_hidden_fields']?(substr_count($entry['altered_hidden_fields'], '"')/4):0);
				$entries[$key]['apis'] = $activeApis ;
			
				
				
				
				// only show these api results if dontDetectCatpchaOnFail = 0 or (dontDetectCatpchaOnFail = 1 and captcha has failed)
				$captcha_passed = true;
				$rErrors = unserialize($entry['registration_errors']);
				if (in_array("did_not_complete_the_captcha_verification_properly", $rErrors)) 
				{
					$captcha_passed = false;	
				}
				
				
				
				$api_feilds = "";
				
				$dontCheckApiCaptchFail = $options->aaDontCheckApiCaptchFail;
				if($dontCheckApiCaptchFail == 0 || ($dontCheckApiCaptchFail == 1 && $captcha_passed == true))
				{
					foreach($activeApis as $sbKy => $activeApi) 
					{
						$entries[$key]['apis'][$sbKy]['is_spam'] = $entry['is_spam_api'.$activeApi['id']];
						$isSpam = ($entry['is_spam_api'.$activeApi['id']] == 1 ? 'TRUE' : 'FALSE' );					
						$class = ($entry['is_spam_api'.$activeApi['id']] == 1 ? 'pRed' : 'pDarker' );
						$api_feilds .= '<div><span class="pfaint">Detected on '.$activeApi['name'].'</span> <span class="'.$class.'"> '.$isSpam.'</span></div>';
						
					}
				}
				
				
				$entries[$key]['api_fields'] = $api_feilds;
			}
			
			
			
			
			$totalItems = $this->_getLogModel()->countLogs($username, $email, $filter);
			
			
			
// needed for fbhp_page_nav			
			
			
			$pageTotal = ceil($totalItems / $perPage);
			$currentPage = min(max($page, 1), $pageTotal);
			// number of pages either side of the current page
			$range = 2;
			$scrollSize = 1 + 2 * $range;
			$scrollThreshold = $scrollSize + 2;
	
			if ($pageTotal >$scrollThreshold)
			{
				$startPage = max(2, $currentPage - $range);
				$endPage = min($pageTotal, $startPage + $scrollSize);
	
				$extraPages = $scrollSize - ($endPage - $startPage);
				if ($extraPages > 0)
				{
					$startPage -= $extraPages;
				}
			}
			else
			{
				$startPage = 2;
				$endPage = $pageTotal;
			}
	
			if ($endPage > $startPage)
			{
				$endPage--;
				$pages = range($startPage, $endPage);
			}
			else
			{
				$pages = array();
			}
			
			
			
			
// end fbhp_page_nav
			
			
			
			
						
			
			
			$viewParams = array(
				'second_api_name' => $options->secondApiName,
				'third_api_name' => $options->thirdApiName,
				
				'pageTotal' => $pageTotal,
				'entries' => $entries,
				'page' => $page,
				'perPage' => $perPage,
				'regTime' => $options->fbhp_min_reg_time,
				'total' => $totalItems,
				'username' => $username,
				'email' => $email,
				'filter' => $filter,
				
				'currentPage' => $currentPage,
				'pages' => $pages,
				'range' => $range,
				'scrollThreshold' => $scrollThreshold,
				'startPage' => $startPage,
				'endPage' => $endPage,
				'prevPage' => ($currentPage > 1 ? ($currentPage - 1) : false),
				'nextPage' => ($currentPage < $pageTotal ? ($currentPage + 1) : false),
				'pageNumberSentinel' => XenForo_Application::$integerSentinel,
				'maxDigits' => strlen($pageTotal),
				
				'linkType' => 'foolbothoneypot/logs',
				'linkData' => false,
				'linkParams' => array('username' => $username, 'email' => $email, 'filter' => $filter),
				
				
			);
			
			
			return $this->responseView('XenForo_ViewAdmin_Log_ServerError', 'foolbothoneypot_log', $viewParams);
		}
	}

	public function actionDelete()
	{
		$id = $this->_input->filterSingle('id', XenForo_Input::UINT);
		$entry = $this->_getLogModel()->getLogById($id);
		if (!$entry)
		{
			return $this->responseError(new XenForo_Phrase('sf_requested_log_entry_not_found'), 404);
		}

		if ($this->isConfirmedPost())
		{
			$this->_getLogModel()->deleteLog($id);

			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildAdminLink('foolbothoneypot/logs')
			);
		}
		else
		{
			$viewParams = array(
				'entry' => $entry
			);
			return $this->responseView('XenForo_ViewAdmin_Log_ServerErrorDelete', 'log_foolbothoneypot_delete', $viewParams);
		}
	}

	public function actionClear()
	{
		if ($this->isConfirmedPost())
		{
			$this->_getLogModel()->clearLog();

			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildAdminLink('foolbothoneypot/logs')
			);
		}
		else
		{
			$viewParams = array();
			return $this->responseView('XenForo_ViewAdmin_Log_ServerErrorDelete', 'foolbothoneypot_log_clear', $viewParams);
		}
	}


	
	public function actionClearbots()
	{
		if ($this->isConfirmedPost())
		{
			$this->_getLogModel()->clearBotsLog();

			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildAdminLink('foolbothoneypot/logs')
			);
		}
		else
		{
			$viewParams = array();
			return $this->responseView('XenForo_ViewAdmin_Log_ServerErrorDelete', 'foolbothoneypot_botslog_clear', $viewParams);
		}
	}
	
	
	
	
	
		


	protected function _getLogModel()
	{
		return $this->getModelFromCache('Tac_FoolBotHoneyPot_Model_Log');
	}
}