<?php

/**
 * View to handle displaying an attachment.
 *
 * @package XenForo_Attachment
 */
class Tac_CustomImgCaptcha_ViewPublic_CicImg_View extends XenForo_ViewPublic_Base
{
	public function renderRaw()
	{

		$captchaModel = XenForo_Model::create('Tac_CustomImgCaptcha_Model_Captcha'); 
		
		$private_uuid = $this->_params['private_uuid'];
		$public_uuid = $this->_params['public_uuid'];		
		
		
		// get the image from the db
		$CicImg = array();
		if(!$private_uuid)
		{
			$private_uuid = $captchaModel->getPrivateUUID($public_uuid);
		}				
		
		$CicImg = $captchaModel->getCaptchaByUUID($private_uuid);
		
		$extension = XenForo_Helper_File::getFileExtension($CicImg['file_name']);
		$imageTypes = array(
			'gif' => 'image/gif',
			'jpg' => 'image/jpeg',
			'jpeg' => 'image/jpeg',
			'jpe' => 'image/jpeg',
			'png' => 'image/png'
		);





		if (in_array($extension, array_keys($imageTypes)))
		{
			$this->_response->setHeader('Content-type', $imageTypes[$extension], true);
			
		}
		else
		{
			$this->_response->setHeader('Content-type', 'application/octet-stream', true);
		}

		
		$this->_response->setHeader('ETag', $CicImg['insert_time'], true);
		// so it's harder to do a bianry comparison on these images, create the image with radom quality 75-100		 
		
		if($CicImg['img'])
		{
						
			$img = imagecreatefromstring($CicImg['img']);
			
			imagefilter($img, IMG_FILTER_BRIGHTNESS, rand(0, 10)); // brightness
			imagefilter($img, IMG_FILTER_CONTRAST, rand(0, 10)); // contrast
			imagefilter($img, IMG_FILTER_SMOOTH, rand(10, 90)); // smoothness
			
			
			
			if($extension == 'jpg' || $extension == 'jpeg' || $extension == 'jpe' || $extension == 'png')
			{
				ob_start();
				imagejpeg($img, NULL, rand(60, 100)); //  quality
				$img = ob_get_clean();
			}
			else if($extension == 'png')
			{
				ob_start();
				imagepng($img, NULL, rand(60, 100)); //  quality
				$img = ob_get_clean();		
			}	
			else if($extension == 'gif')
			{
				ob_start();
				imagegif($img, NULL, rand(60, 100)); //  quality
				$img = ob_get_clean();
			}	
			else 
			{
				$img = $CicImg['img'];
				
			}
					
			return $img;
		}
		return;
		
	}

	
	
	

	
}