<?php

/**
 * View to handle displaying an attachment.
 *
 * @package XenForo_Attachment
 */
class Tac_CustomImgCaptcha_ViewPublic_CicImg_View extends XenForo_ViewPublic_Base
{
	public function renderRaw()
	{

		$captchaModel = XenForo_Model::create('Tac_CustomImgCaptcha_Model_Captcha'); 
		
		$private_uuid = $this->_params['private_uuid'];
		$public_uuid = $this->_params['public_uuid'];		
		
		
		// get the image from the db
		$CicImg = array();
		if(!$private_uuid)
		{
			$private_uuid = $captchaModel->getPrivateUUID($public_uuid);
		}				
		
		$CicImg = $captchaModel->getCaptchaByUUID($private_uuid);
		
		$extension = XenForo_Helper_File::getFileExtension($CicImg['file_name']);
		$imageTypes = array(
			'gif' => 'image/gif',
			'jpg' => 'image/jpeg',
			'jpeg' => 'image/jpeg',
			'jpe' => 'image/jpeg',
			'png' => 'image/png'
		);

		$this->_response->setHeader('Content-type','image/png' , true);
		if (in_array($extension, array_keys($imageTypes)))
		{
			$this->_response->setHeader('Content-type', $imageTypes[$extension], true);
		}
		else
		{
			$this->_response->setHeader('Content-type', 'application/octet-stream', true);
		}

		$this->_response->setHeader('ETag', $CicImg['insert_time'], true);
		$this->_response->setHeader('X-Content-Type-Options', 'nosniff');
		return $CicImg['img'];
		

		
	}

	
	
	

	
}