<?php

class Tac_CustomImgCaptcha_Option_Uploader extends XenForo_ControllerAdmin_Abstract
{
	

	
	public static function renderOption(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
	{
		$value = $preparedOption['option_value'];

		$editLink = $view->createTemplateObject('option_list_option_editlink', array(
			'preparedOption' => $preparedOption,
			'canEditOptionDefinition' => $canEdit
		));
		
		$captchaModel = XenForo_Model::create('Tac_CustomImgCaptcha_Model_Captcha'); // we only need the uuids to display the images (via img.php)
  			
		//$page = $this->_input->filterSingle('page', XenForo_Input::UINT); // no access to object in static context
		//$page = XenForo_Input::filterSingle('page', XenForo_Input::UINT);
	
		if (isSet($_GET["page"]) && is_numeric($_GET["page"]))
		{
			$page = $_GET["page"];
		}
		else
		{
			$page = 1;
		}
		
		
		$addonFBHP = XenForo_Model::create('XenForo_Model_AddOn')->getAddOnById('FoolBotHoneyPot');
		$addonFBHPActive = $addonFBHP ? true : false; // check if FoolBotHoneyPot is installed (else return false)
		if($addonFBHPActive){
			$addonFBHPActive = empty($addonFBHP['active']) ? false : true;  // check that it's active
		}
		// we now need to check that the right type of FBHP logging is switched on
		$fbhpLogEvents = false;
		$options = XenForo_Application::get('options');
		if($addonFBHPActive){			
			$fbhpLogEvents = ($options->fbhpLogEvents == 1)? true : false; // check that we are logging events 
			// (we are making the assumption the bot can't break FBHP, so there is no need make use of logs,just let FBHP detect "bot-ness" 
			// we only need to check that FBHP is installed and active (addonFBHPActive)
		}
		
		$cicLogEvents = ($options->cicLogEvents == "logAll")? true : false; // check that cic is logging both passes and failed attempts
		
		$perPage = 5;
		$entries = $captchaModel->getPrivateUUIDsAndAnswers(array(
				'page' => $page,
				'perPage' => $perPage
			));
		
		$countModel = XenForo_Model::create('Tac_CustomImgCaptcha_Model_Counts');	
		foreach($entries as $key => $entry)
		{	
			$counts = $countModel->getCountsForCaptcha($entries[$key]['private_uuid']);
			if(!$counts){$counts == false;}
			$entries[$key]['counts'] = $counts;
		}	
				

			
		
		$viewParams = array(
			'entries' => $entries,
			'page' => $page,
			'perPage' => $perPage,
			'total' => $captchaModel->countRows(),
			'addonFBHPActive' => $addonFBHPActive,
			'fbhpLogEvents' => $fbhpLogEvents,
			'cicLogEvents' => $cicLogEvents,
			'fieldPrefix' => $fieldPrefix,
			'preparedOption' => $preparedOption,
			'editLink' => $editLink,
			'value' => isset($preparedOption['option_value']) ? $preparedOption['option_value'] : '',
		);
			
		return $view->createTemplateObject('customimgcaptcha_options_options', $viewParams);	
					

	}
	

	
}