<?php

class Tac_CustomImgCaptcha_Model_Uuids extends XenForo_Model
{


	public function getUuidsById($id)
	{
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM sf_customimgcaptcha_uuids 
			WHERE id = ?
		', $id);
	}


	public function getUuidsByPublicUuid($public_uuid)
	{
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM sf_customimgcaptcha_uuids 
			WHERE public_uuid = ?
		', $public_uuid);
	}

		
	public function deleteUuidsBeforeTime($insert_time)
	{
		// give a 24hr gap (alows for daylight saving / server time issues)
		$yesterday = $insert_time - (24*3600);
		
		$this->_getDb()->delete('sf_customimgcaptcha_uuids', 'insert_time < ' . $yesterday );
		
		return  true;

	}


	public function getLastUUID()
	{
		return $this->_getDb()->fetchOne('
			SELECT *
			FROM sf_customimgcaptcha_uuids
			ORDER BY id DESC Limit 1
		');
	}
	
		
	public function countRows()
	{
		return $this->_getDb()->fetchOne('
			SELECT COUNT(id)
			FROM sf_customimgcaptcha_uuids
		');
	}



}