<?php

class Tac_CustomImgCaptcha_Listener
{


	/**
	 * Extend XenForo controller 
	 */
	 
	public static function listenController($class, array &$extend)
	{
		
		$options = XenForo_Application::get('options');
		if($options->cicStopBottersEnabled == 1) // in my case, we never need to use this actionRegister if stopBotters in disabled
		{
					
			if ($class == 'XenForo_ControllerPublic_Register')
			{					
				$alreadySwitchedOn = false;	
				// also, in my case, I don't want to switch this on if it's already switched on in FBHP (FBHP provides more information about bots)
				$addOnModel = XenForo_Model::create('XenForo_Model_AddOn');
				if (($addon = $addOnModel->getAddOnById('FoolBotHoneyPot')) && (!empty($addon['active'])) && ($options->fbhpStopBottersEnabled == 1))
				{
					$alreadySwitchedOn = true;	
				}

				if($alreadySwitchedOn == false)
				{
						$extend[] = 'Tac_CustomImgCaptcha_ControllerPublic_Register';
				}
						
				
			}
			
			
		}	
	}


	public static function init(XenForo_Dependencies_Abstract $dependencies, array $data)
    {
       
        XenForo_Template_Helper_Core::$helperCallbacks += array(
            'public-cic-img' => array('Tac_CustomImgCaptcha_Helpers_Template', 'publicCicImg')
        );
    }
	
	
	
	public static function optionCaptchaRender(&$extraChoices, $view, $preparedOption)
	{
		$extraChoices['custom_img_captcha'] = array(
			"label" => new XenForo_Phrase('use_custom_img_captcha'),
			"hint" => new XenForo_Phrase('add_your_custom_images_first'),
			"value" => "Tac_CustomImgCaptcha_Captcha_Captcha"
		);
	}


}