<?php

class Tac_CustomImgCaptcha_Install
{
	public static function installCode()
	{
		$db = XenForo_Application::get('db');

		$db->query("
			CREATE TABLE IF NOT EXISTS `sf_customimgcaptcha_answers` (
			  `id` int(11) NOT NULL AUTO_INCREMENT,
			  `img` mediumblob NOT NULL,
			  `img_type` varchar(70) NOT NULL,
			  `private_uuid` varchar(26) NOT NULL,
			  `file_name` varchar(160) NOT NULL,
			  `width` int(4) NOT NULL,
			  `height` int(4) NOT NULL,
			  `answers` text NOT NULL,
			  `insert_time` int(11) NOT NULL,
			  PRIMARY KEY (`id`)
			) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;	
		");
		
 		$db->query("
			CREATE TABLE IF NOT EXISTS `sf_customimgcaptcha_uuids` (
			  `id` int(11) NOT NULL AUTO_INCREMENT,
			  `public_uuid` varchar(26) NOT NULL,
			  `private_uuid` varchar(26) NOT NULL,
			  `file_name` varchar(160) NOT NULL,
			  `answers` text NOT NULL,
			  `insert_time` int(11) NOT NULL,
			  PRIMARY KEY (`id`)
			) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;
	 	");

		$db->query("
		 	CREATE TABLE IF NOT EXISTS `sf_customimgcaptcha_accesskeys` (
			  `id` int(11) NOT NULL AUTO_INCREMENT,
			  `file_name` varchar(20) NOT NULL,
			  `access_key` varchar(26) NOT NULL,
			  `update_time` int(11) DEFAULT NULL,
			  PRIMARY KEY (`id`),
			  UNIQUE KEY `access_key` (`access_key`),
			  UNIQUE KEY `file_name` (`file_name`)
			) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;
	 	");
	
		$db->query("
			CREATE TABLE IF NOT EXISTS `sf_customimgcaptcha_log` (
			  `log_id` int(10) NOT NULL AUTO_INCREMENT,
			  `log_date` int(10) NOT NULL,
			  `private_uuid` varchar(26) NOT NULL, 
			  `file_name` varchar(160) NOT NULL,
			  `passed` int(1) NOT NULL DEFAULT '0',
			  `possible_human` int(1) NOT NULL DEFAULT '0',		  
			  `ip_address` text NOT NULL,
			  `username` varchar(50) NOT NULL,
			  `email` varchar(120) NOT NULL,
			  `user_answer` varchar(180) NOT NULL,
			  `expected_answer` text NOT NULL,
			  `message` text NOT NULL,
			  `details` text NOT NULL,
			  `full_url` text NOT NULL,
			  PRIMARY KEY (`log_id`)
			) ENGINE=InnoDB  DEFAULT CHARSET=utf8 ;
	 	");
		
		$db->query("
			CREATE TABLE IF NOT EXISTS `sf_customimgcaptcha_counts` (
			  `id` int(10) NOT NULL AUTO_INCREMENT,
			  `private_uuid` varchar(25) NOT NULL,
			  `human_passed` int(10) NOT NULL DEFAULT '0',
			  `human_failed` int(10) NOT NULL DEFAULT '0',
			  `bot_passed` int(10) NOT NULL DEFAULT '0',
			  `bot_failed` int(10) NOT NULL DEFAULT '0',
			  PRIMARY KEY (`id`),
			  UNIQUE KEY `private_uuid` (`private_uuid`)
			) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
	 	");

		$db->query("		
			CREATE TABLE IF NOT EXISTS `sf_stopbotters` (
			  `id` int(11) NOT NULL AUTO_INCREMENT,
			  `ip_address` varchar(30) NOT NULL,
			  `known_bot` int(1) NOT NULL DEFAULT '0',
			  `time_stamp` int(11) NOT NULL,
			  PRIMARY KEY (`id`)
			) ENGINE=InnoDB DEFAULT CHARSET=utf8;
		");	
		
		
		self::addColumnIfNotExist($db, "sf_customimgcaptcha_log", "full_url", "text NOT NULL");
		
		self::modifyTableType($db, "sf_customimgcaptcha_log", "ip_address", "varbinary(16) NOT NULL");
		
		$isUpgrade = self::tableHasRows($db, "sf_customimgcaptcha_answers", 'id');
		
	
		if(!$isUpgrade)
		{	
		
		$rand = md5(rand());
		$randomPrefix = substr($rand, 0, 12); // to avoid colision when the same uuid is created (from same milisec)
		$access_key = uniqid($randomPrefix);
		
		$db->query("
		INSERT INTO `sf_customimgcaptcha_accesskeys` (`id`, `file_name`, `access_key`, `update_time`) VALUES
		(1, 'export', '".$access_key."', 1350834263);		
		");
	
	
		$db->query("
		INSERT INTO `sf_customimgcaptcha_answers` (`id`, `img`, `img_type`, `private_uuid`, `width`, `height`, `file_name`, `answers`, `insert_time`) VALUES (4545557, 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, 'image/jpeg', '8feddc18ebc5508416431bf55', 300, 200, 'example1', 'shoe,shoes,a shoe', 1350833855)
		");

		$db->query("
		INSERT INTO `sf_customimgcaptcha_answers` (`id`, `img`, `img_type`, `private_uuid`, `width`, `height`, `file_name`, `answers`, `insert_time`) VALUES (4545558, 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, 'image/jpeg', 'f9e613692de050841648e0fd9', 300, 200, 'example2', 'spoon,spoons,a spoon', 1350833842)
		");
		
		$db->query("
		INSERT INTO `sf_customimgcaptcha_answers` (`id`, `img`, `img_type`, `private_uuid`, `width`, `height`, `file_name`, `answers`, `insert_time`) VALUES (4545559, 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, 'image/jpeg', '4619fc1a5d71508416528a541', 300, 200, 'example3', 'screw,screws,a screw', 1350838389)	
		");
		
		$db->query("
		INSERT INTO `sf_customimgcaptcha_answers` (`id`, `img`, `img_type`, `private_uuid`, `width`, `height`, `file_name`, `answers`, `insert_time`) VALUES (4545560, 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, 'image/jpeg', 'fbc4bc535f955084165aadee3', 300, 200, 'example4', 'stamp,stamps,a stamp', 1350833822)	
		");
			
		}


		return true;
	}
	
	
	
	
	
	public static function modifyTableType($db, $table, $field, $attr)
	{	
		$db->query("ALTER TABLE `".$table."` MODIFY `".$field."` ".$attr); 
	}
	
	
	public static function uninstallCode()
	{
		$db = XenForo_Application::get('db');
		
		// drop tables
		$db->query("
			DROP TABLE IF EXISTS
				`sf_customimgcaptcha_answers`,
				`sf_customimgcaptcha_uuids`,
				`sf_customimgcaptcha_log`,	
				`sf_customimgcaptcha_accesskeys`,
				`sf_customimgcaptcha_counts`	
		");
		return true;
	}

	
	public static function addColumnIfNotExist($db, $table, $field, $attr)
	{
		if ($db->fetchRow('SHOW columns FROM `'.$table.'` WHERE Field = ?', $field))
		{
			return false;
		}
		
		return $db->query("ALTER TABLE `".$table."` ADD `".$field."` ".$attr);
	}
	
	
	public static function tableHasRows($db, $tableName, $col)
	{
		$stmt  = $db->query('SELECT COUNT('.$col.') AS c FROM '.$tableName.' LIMIT 1');
		$row = $stmt->fetch();
		$num_rows = $row['c'];
		if($num_rows > 0){return true;}
		return false;	
	}
	

	
	

}
