<?php


class Tac_CustomImgCaptcha_DataWriter_Uuids extends XenForo_DataWriter
{

	protected function _getFields()
	{
		return array(
			'sf_customimgcaptcha_uuids' => array(
				'id'            	=> array('type' => self::TYPE_UINT, 'autoIncrement' => true),
				'public_uuid'     	=> array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 26),
				'private_uuid'     	=> array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 26),
				'file_name'	   		=> array('type' => self::TYPE_STRING, 'maxLength' => 160, 'default' => 'unnamed'),
				'answers'      		=> array('type' => self::TYPE_STRING),
				'insert_time'     	=> array('type' => self::TYPE_UINT, 'required' => true, 'maxLength' => 11),
			)
		);
	}


	protected function _getUuidsModel()
	{
		return $this->getModelFromCache('Tac_CustomImgCaptcha_Model_Uuids');
	}


	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data))
		{
			return false;
		}

		return array('sf_customimgcaptcha_uuids' => $this->_getUuidsModel()->getUuidsById($id));
	}


	protected function _getUpdateCondition($tableName)
	{
		return 'id = ' . $this->_db->quote($this->getExisting('id'));
	}


}