<?php


class Tac_CustomImgCaptcha_DataWriter_Log extends XenForo_DataWriter
{

	protected function _getFields()
	{
		// it would be a good idea to put a custom limit on the user_answer size (to stop mulitiple answers from *my ans*)
		// this should be client side validated to also help humans
		
		return array(
			'sf_customimgcaptcha_log' => array(
				'log_id'        	  	=> array('type' => self::TYPE_UINT, 	'autoIncrement' => true, 	'maxLength' => 10 ),
				'log_date'     			=> array('type' => self::TYPE_UINT, 	'default' => 0, 			'maxLength' => 10 ),
				'private_uuid'     		=> array('type' => self::TYPE_STRING, 	'default' => '', 			'maxLength' => 26),
				'file_name'	   			=> array('type' => self::TYPE_STRING, 	'default' => 'unnamed', 	'maxLength' => 160),
				'passed' 				=> array('type' => self::TYPE_UINT, 	'default' => 0, 			'maxLength' => 1), 
				'possible_human' 		=> array('type' => self::TYPE_UINT, 	'default' => 1, 			'maxLength' => 1),
				'ip_address' 			=> array('type' => self::TYPE_STRING, 	'default' => ''),
				'username'  			=> array('type' => self::TYPE_STRING, 	'default' => '', 			'maxLength' => 50),
				'email'  				=> array('type' => self::TYPE_STRING, 	'default' => '', 			'maxLength' => 120),
				'expected_answer'		=> array('type' => self::TYPE_STRING, 	'default' => ''),
				'user_answer' 			=> array('type' => self::TYPE_STRING, 	'default' => '', 			'maxLength' => 180), 
				'message'     			=> array('type' => self::TYPE_STRING, 	'default' => ''),
				'details'     			=> array('type' => self::TYPE_STRING, 	'default' => ''),
				'full_url'     			=> array('type' => self::TYPE_STRING, 	'default' => ''),
				
			)
		);
	}


	
	
	
	protected function _getCaptchaLog()
	{
		return $this->getModelFromCache('Tac_CustomImgCaptcha_Model_Log');
	}


	protected function _getExistingData($data)
	{
		if (!$log_id = $this->_getExistingPrimaryKey($data))
		{
			return false;
		}

		return array('sf_customimgcaptcha_log' => $this->_getCaptchaLog()->getLogById($id));
	}


	protected function _getUpdateCondition($tableName)
	{
		return 'log_id = ' . $this->_db->quote($this->getExisting('log_id'));
	}


}