<?php


class Tac_CustomImgCaptcha_DataWriter_Counts extends XenForo_DataWriter
{

	protected function _getFields()
	{
		return array(
			'sf_customimgcaptcha_counts' => array(
				'id'            	=> array('type' => self::TYPE_UINT, 'autoIncrement' => true),
				'private_uuid'     	=> array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 26),
				'human_passed'     	=> array('type' => self::TYPE_UINT, 'maxLength' => 10, 'default' => 0),
				'human_failed'     	=> array('type' => self::TYPE_UINT, 'maxLength' => 10, 'default' => 0),
				'bot_passed'     	=> array('type' => self::TYPE_UINT, 'maxLength' => 10, 'default' => 0),
				'bot_failed'     	=> array('type' => self::TYPE_UINT, 'maxLength' => 10, 'default' => 0),
			)
		);
	}


	protected function _getCountsModel()
	{
		return $this->getModelFromCache('Tac_CustomImgCaptcha_Model_Counts');
	}


	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data))
		{
			return false;
		}

		return array('sf_customimgcaptcha_counts' => $this->_getCountsModel()->getCountsById($id));
	}


	protected function _getUpdateCondition($tableName)
	{
		return 'id = ' . $this->_db->quote($this->getExisting('id'));
	}


}