<?php


class Tac_CustomImgCaptcha_DataWriter_Captcha extends XenForo_DataWriter
{

	protected function _getFields()
	{
		return array(
			'sf_customimgcaptcha_answers' => array(
				'id'            	=> array('type' => self::TYPE_UINT, 'autoIncrement' => true),
				'img'     			=> array('type' => self::TYPE_BINARY, 'required' => true),
				'img_type' 			=> array('type' => self::TYPE_STRING, 'required' => true),
				'private_uuid'     	=> array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 26),
				'answers'      		=> array('type' => self::TYPE_STRING),
				'file_name'	   		=> array('type' => self::TYPE_STRING, 'maxLength' => 160, 'default' => 'unnamed'),
				'width'     		=> array('type' => self::TYPE_UINT, 'maxLength' => 4, 'default' => 300),
				'height'     		=> array('type' => self::TYPE_UINT, 'maxLength' => 4, 'default' => 200),
				'insert_time'     	=> array('type' => self::TYPE_UINT, 'required' => true, 'maxLength' => 11),
			)
		);
	}


	protected function _getCaptchaModel()
	{
		return $this->getModelFromCache('Tac_CustomImgCaptcha_Model_Captcha');
	}


	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data))
		{
			return false;
		}

		return array('sf_customimgcaptcha_answers' => $this->_getCaptchaModel()->getCaptchaById($id));
	}


	protected function _getUpdateCondition($tableName)
	{
		return 'id = ' . $this->_db->quote($this->getExisting('id'));
	}


}