<?php


class Tac_CustomImgCaptcha_DataWriter_AccessKey extends XenForo_DataWriter
{

	protected function _getFields()
	{
		return array(
			'sf_customimgcaptcha_accesskeys' => array(
				'id'            	=> array('type' => self::TYPE_UINT, 'autoIncrement' => true),
				'file_name'         => array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 20),
				'access_key'     	=> array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 26),
				'update_time'     	=> array('type' => self::TYPE_UINT,   'required' => true, 'maxLength' => 11)
			)
		);
	}



	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data))
		{
			return false;
		}
		
		return array('sf_customimgcaptcha_accesskeys' => $this->getModelFromCache('Tac_CustomImgCaptcha_Model_AccessKey')->getKeyById($id));
	}


	protected function _getUpdateCondition($tableName)
	{
		
		return 'id = ' . $this->_db->quote($this->getExisting('id'));
	}


}