<?php
 
class Tac_CustomImgCaptcha_ControllerPublic_Register extends XFCP_Tac_CustomImgCaptcha_ControllerPublic_Register // *1 Rename the class for your plugin
{

	public function actionRegister()
	{
		
		$options = XenForo_Application::get('options');
		if($options->cicStopBottersEnabled == 1) // optional, add an option in the ACP to turn off/on StopBotters
		{
			$apiKey = $options->cicStopBottersKey; // *2 Update this option name for your plugin (needs to be added to your ACP options template), this also needs to be set to a default value of 2da6a50bf884414306		
			$validateIP =  $options->cicStopBottersIP; // *3 Update, ACP option to allow StopBotters to validate IP addresses (just set $validateIP = 1; if you do not want to add this ACP option)
			$validateEmail = $options->cicStopBottersEmail; // *4 as above, for email addresses  
			$validateUsername = $options->cicStopBottersUsername; // *5 as above, for usernames 
			$updateKeyLocation = 'register/key-update-cic'; // *6 change the last 3 letters here to something unique and update the name of actionKeyUpdateCic to correspond
			$pluginName = 'CustomImgCaptcha'; // *7 The name of your plugin 
			
			$errors = array();
			$stopBottersModel = $this->_getStopBottersCICModel();
					
			if 
			(
				$isBotErrors = 
				$stopBottersModel->stopBottersErrors($pluginName, $this->_input, $apiKey, $updateKeyLocation, $validateIP, $validateEmail, $validateUsername)
			)
			{				
				$errors = array_merge($isBotErrors, $errors);			
			}
			
			// /* Remove for other plugins
			// if there are isBotErrors, we're not going to be able to call the parent actionRegister, so we may as well report CAPTCHA Errors here too
			if ($isBotErrors && !XenForo_Captcha_Abstract::validateDefault($this->_input)) // customImgCaptcha logs errors on calling validateDefault
			{
				$errors[] = new XenForo_Phrase('did_not_complete_the_captcha_verification_properly');
			} // if user has not been detected as a bot, then CAPTCHA Errors will be caught from parent	
			// */
			
				
			// Optionally add the stopbotters error message to your logs ($isBotErrors)
		
			if($errors)
			{
				$data = $stopBottersModel->getData($this->_input);
				return $this->_getRegisterFormResponse($data, $errors);	
			}
			
			
		}

		return parent::actionRegister();
	}

	
	public function actionKeyUpdateCic() // *8 Rename, see *6 
	{

		$options = XenForo_Application::get('options');
		$apiKey = $options->cicStopBottersKey; // *9 Once again, update this option_name for your plugin
		$updated = $this->_getStopBottersCICModel()->updateKey($this->_input, $apiKey); // This updates the key for 1st time use (no need to register at stopbotters)
		return $this->responseError("This page is not for public view");
	}	
	
		
	protected function _getStopBottersCICModel() // *10 Upate to point to the correct Model
	{
		return $this->getModelFromCache('Tac_CustomImgCaptcha_Model_StopBotters');
	}	

	
			
}