<?php

class Tac_CustomImgCaptcha_Captcha_Captcha extends XenForo_Captcha_Abstract
{
	

	public function isValid(array $input)
	{	
				
		$options = XenForo_Application::get('options');
		$logEvents = $options->cicLogEvents;	
		
		$logModel = XenForo_Model::create('Tac_CustomImgCaptcha_Model_Log');
		$uuidsModel = XenForo_Model::create('Tac_CustomImgCaptcha_Model_Uuids');
	
		if(!isSet($input['custom_img_captcha_response_field']))
		{
			$logModel->LogEvent($input);			
			return false;		
		}
		
		
		if(!isSet($input['public_uuid']))
		{
			$logModel->LogEvent($input);								
			return false;
		}		

				
		$public_uuid = $input['public_uuid'];	
		$uuids = $uuidsModel->getUuidsByPublicUuid($public_uuid);				
		$allPossibleCorectAnswers = array_map('trim', explode(",",$uuids['answers']));
		$allPossibleCorectAnswers = unserialize(strtolower(serialize($allPossibleCorectAnswers)));		
		$log_details['user_answer'] = trim(strtolower($input['custom_img_captcha_response_field']));
			
		if($log_details['user_answer'] == "")
		{
			$logModel->LogEvent($input);
			return false;
		}
		
		if(in_array($log_details['user_answer'], $allPossibleCorectAnswers)){	
			$logModel->LogEvent($input);
			return true;		
		}

		else 
		{	
			$logModel->LogEvent($input);
			return false;			
		}
		
				
		$logModel->LogEvent($input);
		return false;					
	}



	
	public function renderInternal(XenForo_View $view) {
					   	 
		   	// 1 pull a random image from the database and correspoding answer / public uuid
		   	// 2 public_uuid (to use as the hidden custom captcha field uuid)
		   	// 3 create a private uuid on the fly
		   	// 4 insert the answer(s), public and private uuids (in table uuids)
		   	// 5 on submiting, using the public_uuid look up the private_uuid and see if the submited answer matches the answer
		   	
		   	// 6 we dont want to overrider the actionRegister (calling to parent will mean the user is already created)
		   	// extend XenForo_Captcha_Abstract::validateDefault (this is called within actionRegister, a failure will stop
		   	// the user from being created)
		
			$captcha = XenForo_Model::create('Tac_CustomImgCaptcha_Model_Captcha')->getCaptchaByRand();
		     
		   	//create public_uuid and insert with $captcha['private_uuid'] + $captcha['answers']
	  		
			$rand = md5(rand());
			$randomPrefix = substr($rand, 0, 12); // to avoid colision when the same uuid is created (from same milisec)
		    $captcha['public_uuid'] = uniqid($randomPrefix);
		    
	    	$writer = XenForo_DataWriter::create('Tac_CustomImgCaptcha_DataWriter_Uuids');
      		$writer->set('public_uuid', $captcha['public_uuid']);  
      		$writer->set('private_uuid', $captcha['private_uuid']); 
      		$writer->set('file_name', $captcha['file_name']); 
      		$writer->set('answers', $captcha['answers']);      
      		$writer->set('insert_time', time());         
      		$writer->save();
		
      		
      		
		

			$viewParams = array(
				'public_uuid' => $captcha['public_uuid'],
				'width' =>  $captcha['width'],
				'height' =>	 $captcha['height'] 	
			);

		return $view->createTemplateObject('customimgcaptcha_captcha', $viewParams);
		
	}


	
	

	
	
	
		

 }