<?php

class Tac_AnyApi_Model_ApiSettings extends XenForo_Model
{
	public function getApiSettingsById($id)
	{
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM sf_anyapi_api_settings 
			WHERE id = ?
		', $id);
	}

	
	public function getApiSettings(array $fetchOptions = array())
	{
	   	$limitOptions = $this->prepareLimitFetchOptions($fetchOptions);
	   	return $this->fetchAllKeyed($this->limitQueryResults(
			'
				SELECT *
				FROM sf_anyapi_api_settings
				ORDER BY id ASC				
			', $limitOptions['limit'], $limitOptions['offset']
		), ';id');
	}
	
	
	
	
	

	

	public function countLogs($username = NULL, $email = NULL, $filter = NULL)
	{
		$whereCondition = ($username ? ' WHERE username LIKE "%'.$username.'%"' : '');
		
		if($email) 
		{
			if(!$whereCondition)
			{
				$whereCondition = ' WHERE email LIKE "%'.$email.'%"';
			}
			else
			{
				$whereCondition += ' AND email LIKE "%'.$email.'%"';
			}
		}		

		
				
		if($filter && !$whereCondition) 
		{
			switch ($filter) 
			{
				case 'no_filter':
					$whereCondition = '';
				    break;
				case 'javascript_enabled':
					$whereCondition = ' WHERE javascript_enabled = 1';
				    break;
				case 'javascript_disabled':
					$whereCondition = ' WHERE javascript_enabled = 0';
					break;
				case 'altered_hidden_fields':
					$whereCondition = ' WHERE altered_hidden_fields != "b:0;"';
					break;
				case 'no_altered_hidden_fields':
					$whereCondition = ' WHERE altered_hidden_fields = "b:0;"';
					break;
				case 'registration_time_less_than_30s':
					$whereCondition = ' WHERE registration_time < 30';
					break;
				case 'registration_time_more_than_30s':
					$whereCondition = ' WHERE registration_time > 30';
					break;
			}
		}			
		else if ($filter && $whereCondition) 
		{
			switch ($filter) 
			{
				case 'no_filter':
					$whereCondition += '';
				    break;
				case 'javascript_enabled':
					$whereCondition += ' AND javascript_enabled = 1';
				    break;
				case 'javascript_disabled':
					$whereCondition += ' AND javascript_enabled = 0';
					break;
				case 'altered_hidden_fields':
					$whereCondition += ' AND altered_hidden_fields != "b:0;"';
					break;
				case 'no_altered_hidden_fields':
					$whereCondition += ' AND altered_hidden_fields = "b:0;"';
					break;
				case 'registration_time_less_than_30s':
					$whereCondition += ' AND registration_time < 30';
					break;
				case 'registration_time_more_than_30s':
					$whereCondition += ' AND registration_time > 30';
					break;
			}
		}
		
		
		return $this->_getDb()->fetchOne('
			SELECT COUNT(*)
			FROM sf_foolbothoneypot_log
			'.$whereCondition.'
		');
	}

	public function deleteLog($id)
	{
		$db = $this->_getDb();
		$db->delete('sf_foolbothoneypot_log', 'log_id = ' . $db->quote($id));
	}

	public function clearBotsLog()
	{
		
		$this->_getDb()->query('DELETE FROM sf_foolbothoneypot_log WHERE log_type != "No Bot Triggers Found"');
	}

	public function clearLog()
	{
		$this->_getDb()->query('TRUNCATE TABLE sf_foolbothoneypot_log');
	}	
	
	
	
	public function convertIpToLong($ipAddress = null)
	{
		if ($ipAddress === null)
		{
			$ipAddress = (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : 0);
		}

		if (is_string($ipAddress) && strpos($ipAddress, '.'))
		{
			$ipAddress = ip2long($ipAddress);
		}

		return sprintf('%u', $ipAddress);
	}



}