<?php

class Tac_AnyApi_Install
{
	public static function installCode()
	{	
		$db = XenForo_Application::get('db');
		
		$db->query("		
		CREATE TABLE IF NOT EXISTS `sf_anyapi_api_settings` (
		  `id` int(2) NOT NULL AUTO_INCREMENT,
		  `name` varchar(30) NOT NULL,
		  `url` text NOT NULL,
		  `key` varchar(250) NOT NULL,
		  `data_type` varchar(20) NOT NULL,
		  `rules` text NOT NULL,
		  `logic_set` text NOT NULL,
		  `api_active` int(1) NOT NULL DEFAULT '0',
		  PRIMARY KEY (`id`)
		) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
		");		

		$db->query("		
		CREATE TABLE IF NOT EXISTS `sf_anyapi_log` (
		  `log_id` int(11) NOT NULL AUTO_INCREMENT,
		  `log_date` int(11) NOT NULL,
		  `ip_address` varchar(100) NOT NULL,
		  `username` varchar(200) NOT NULL,
		  `email` varchar(200) NOT NULL,
		  `message` text NOT NULL,
		  `api_request_string` text NOT NULL,
		  `api_response` text NOT NULL,
		  `rules` text NOT NULL,
		  `logic_set` text NOT NULL,
		  `logic_set_bool` text NOT NULL,
		  `is_blocked` int(1) NOT NULL,
		  PRIMARY KEY (`log_id`)
		) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
		");				
		
		$db->query("		
		CREATE TABLE IF NOT EXISTS `sf_anyapi_response_cache` (
		  `id` int(11) NOT NULL AUTO_INCREMENT,
		  `api_request_string` text NOT NULL,
		  `api_response` text NOT NULL,
		  `time_stamp` int(11) NOT NULL,
		  PRIMARY KEY (`id`)
		) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
		");
		
	
		$isUpgrade = self::tableHasRows($db, 'sf_anyapi_api_settings', 'id');
		
		if(!$isUpgrade)
		{
			$db->query(self::getInsertSettings());	
		}

		

		
		return true;
	}

	
	
	
	public static function uninstallCode()
	{
		$db = XenForo_Application::get('db');
		// drop tables
		$db->query("
			DROP TABLE IF EXISTS
				`sf_anyapi_api_settings`, 
				`sf_anyapi_log`,
				`sf_anyapi_response_cache`
		");
		return true;
	}

	
	public static function addColumnIfNotExist($db, $table, $field, $attr)
	{
		if ($db->fetchRow('SHOW columns FROM `'.$table.'` WHERE Field = ?', $field))
		{
			return false;
		}
		
		return $db->query("ALTER TABLE `".$table."` ADD `".$field."` ".$attr);
	}
	
	
	public static function tableHasRows($db, $tableName, $rowName)
	{
		$stmt  = $db->query('SELECT COUNT('.$rowName.') AS c FROM '.$tableName.' LIMIT 1');
		$row = $stmt->fetch();
		$num_rows = $row['c'];
		if($num_rows > 0){return true;}
		return false;	
	}
	
	public static function getInsertSettings()
	{
		// I hade to url encode, since { % $ [ were throwing parse errors
	return urlDecode("INSERT%20INTO%20%60sf_anyapi_api_settings%60%20(%60id%60%2C%20%60name%60%2C%20%60url%60%2C%20%60key%60%2C%20%60data_type%60%2C%20%60rules%60%2C%20%60logic_set%60%2C%20%60api_active%60)%20VALUES%0A%09%09%09%09(1%2C%20'Stop%20Forum%20Spam'%2C%20'http%3A%2F%2Fwww.stopforumspam.com%2Fapi%3Fip%3D%7B%24ip%7D%26email%3D%7B%24email%7D%26f%3Djson'%2C%20''%2C%20'json'%2C%20'a%3A10%3A%7Bi%3A1%3Bs%3A90%3A%22%7B%24response%5B''email''%5D%5B''lastseen''%5D%7D%20%3E%200%20%2F%2F%20bot%20emails%20banned%20forever%2C%20you%20dont%20need%20this%20line%22%3Bi%3A2%3Bs%3A74%3A%22%7B%24response%5B''email''%5D%5B''confidence''%5D%7D%20%3E%2090.01%20%2F%2F%20more%20than%2090.01%20%25%20confidence%22%3Bi%3A3%3Bs%3A84%3A%22%7B%24response%5B''email''%5D%5B''appears''%5D%7D%20%3E%200%20%2F%2F%20appears%20once%20or%20more%2C%20you%20dont%20need%20this%20line%22%3Bi%3A4%3Bs%3A61%3A%22%7B%24response%5B''ip''%5D%5B''lastseen''%5D%7D%20%3E%20%24timenow%20-%201814400%20%2F%2F%203%20weeks%22%3Bi%3A5%3Bs%3A71%3A%22%7B%24response%5B''ip''%5D%5B''confidence''%5D%7D%20%3E%2090.01%20%2F%2F%20more%20than%2090.01%20%25%20confidence%22%3Bi%3A6%3Bs%3A81%3A%22%7B%24response%5B''ip''%5D%5B''appears''%5D%7D%20%3E%200%20%2F%2F%20appears%20once%20or%20more%2C%20you%20dont%20need%20this%20line%22%3Bi%3A7%3Bs%3A0%3A%22%22%3Bi%3A8%3Bs%3A0%3A%22%22%3Bi%3A9%3Bs%3A0%3A%22%22%3Bi%3A10%3Bs%3A0%3A%22%22%3B%7D'%2C%20'(Rule1%20AND%20Rule2%20AND%20Rule3)%20OR%20(Rule4%20AND%20Rule5%20AND%20Rule6)'%2C%201)%2C%0A%09%09%09%09(2%2C%20'FSpamlist'%2C%20'http%3A%2F%2Fwww.fspamlist.com%2Fapi.php%3Fkey%3D%7B%24key%7D%26spammer%3D%7B%24email%7D%2C%7B%24ip%7D%26json'%2C%20'ADD_YOUR_KEY'%2C%20'json'%2C%20'a%3A10%3A%7Bi%3A1%3Bs%3A43%3A%22%7B%24response%5B0%5D%5B''isspammer''%5D%7D%20%3D%20true%20%2F%2F%20email%22%3Bi%3A2%3Bs%3A40%3A%22%7B%24response%5B1%5D%5B''isspammer''%5D%7D%20%3D%20true%20%2F%2F%20ip%22%3Bi%3A3%3Bs%3A75%3A%22%7B%24response%5B1%5D%5B''lastseen''%5D%7D%20%3E%20%24timenow%20-%201814400%20%2F%2F%20ip%20less%20than%203%20weeks%20old%22%3Bi%3A4%3Bs%3A0%3A%22%22%3Bi%3A5%3Bs%3A0%3A%22%22%3Bi%3A6%3Bs%3A0%3A%22%22%3Bi%3A7%3Bs%3A0%3A%22%22%3Bi%3A8%3Bs%3A0%3A%22%22%3Bi%3A9%3Bs%3A0%3A%22%22%3Bi%3A10%3Bs%3A0%3A%22%22%3B%7D'%2C%20'(Rule1)%20OR%20(Rule2%20AND%20Rule3)'%2C%200)%2C%0A%09%09%09%09(3%2C%20'Bot%20Scout'%2C%20'http%3A%2F%2Fbotscout.com%2Ftest%2F%3Fmulti%26mail%3D%7B%24email%7D%26ip%3D%7B%24ip%7D'%2C%20''%2C%20'plain_text'%2C%20'a%3A10%3A%7Bi%3A1%3Bs%3A30%3A%22%7B%24response%7D%20contains%20''Y%7CMULTI''%22%3Bi%3A2%3Bs%3A30%3A%22%7B%24response%7D%20!contains%20''MAIL%7C0''%22%3Bi%3A3%3Bs%3A28%3A%22%7B%24response%7D%20!contains%20''IP%7C0''%22%3Bi%3A4%3Bs%3A0%3A%22%22%3Bi%3A5%3Bs%3A0%3A%22%22%3Bi%3A6%3Bs%3A0%3A%22%22%3Bi%3A7%3Bs%3A0%3A%22%22%3Bi%3A8%3Bs%3A0%3A%22%22%3Bi%3A9%3Bs%3A0%3A%22%22%3Bi%3A10%3Bs%3A0%3A%22%22%3B%7D'%2C%20'(Rule1)%20AND%20(Rule2%20OR%20Rule3)'%2C%201)%2C%0A%09%09%09%09(4%2C%20'Spam%20Busted'%2C%20'http%3A%2F%2Fwww.spambusted.com%2Fapi.php%3Femail%3D%7B%24email%7D%26ip%3D%7B%24ip%7D'%2C%20''%2C%20'plain_text'%2C%20'a%3A10%3A%7Bi%3A1%3Bs%3A26%3A%22%7B%24response%7D%20contains%20''Yes''%22%3Bi%3A2%3Bs%3A0%3A%22%22%3Bi%3A3%3Bs%3A0%3A%22%22%3Bi%3A4%3Bs%3A0%3A%22%22%3Bi%3A5%3Bs%3A0%3A%22%22%3Bi%3A6%3Bs%3A0%3A%22%22%3Bi%3A7%3Bs%3A0%3A%22%22%3Bi%3A8%3Bs%3A0%3A%22%22%3Bi%3A9%3Bs%3A0%3A%22%22%3Bi%3A10%3Bs%3A0%3A%22%22%3B%7D'%2C%20'(Rule1)'%2C%201)%2C%0A%09%09%09%09(5%2C%20'Project%20Honey%20Pot%20Http%3ABL'%2C%20'%7B%24key%7D.%7B%24reverse_octet_ip%7D.dnsbl.httpbl.org'%2C%20'ADD_YOUR_KEY'%2C%20'octet'%2C%20'a%3A10%3A%7Bi%3A1%3Bs%3A68%3A%22%7B%24response%5B0%5D%7D%20%3D%20127%20%2F%2F%20all%20Http%3ABL%20start%20with%20127%20for%20the%201st%20octet%22%3Bi%3A2%3Bs%3A54%3A%22%7B%24response%5B1%5D%7D%20%3C%2021%20%2F%2F%20last%20seen%20less%20than%2021%20days%20ago%22%3Bi%3A3%3Bs%3A58%3A%22%7B%24response%5B2%5D%7D%20%3E%2020%20%2F%2F%20must%20have%20a%20threat%20score%20of%20over%2020%22%3Bi%3A4%3Bs%3A0%3A%22%22%3Bi%3A5%3Bs%3A0%3A%22%22%3Bi%3A6%3Bs%3A0%3A%22%22%3Bi%3A7%3Bs%3A0%3A%22%22%3Bi%3A8%3Bs%3A0%3A%22%22%3Bi%3A9%3Bs%3A0%3A%22%22%3Bi%3A10%3Bs%3A0%3A%22%22%3B%7D'%2C%20'(Rule1%20AND%20Rule2%20AND%20Rule3)'%2C%200)%2C%0A%09%09%09%09(6%2C%20''%2C%20''%2C%20''%2C%20'json'%2C%20'a%3A10%3A%7Bi%3A1%3Bs%3A0%3A%22%22%3Bi%3A2%3Bs%3A0%3A%22%22%3Bi%3A3%3Bs%3A0%3A%22%22%3Bi%3A4%3Bs%3A0%3A%22%22%3Bi%3A5%3Bs%3A0%3A%22%22%3Bi%3A6%3Bs%3A0%3A%22%22%3Bi%3A7%3Bs%3A0%3A%22%22%3Bi%3A8%3Bs%3A0%3A%22%22%3Bi%3A9%3Bs%3A0%3A%22%22%3Bi%3A10%3Bs%3A0%3A%22%22%3B%7D'%2C%20''%2C%200)%2C%0A%09%09%09%09(7%2C%20''%2C%20''%2C%20''%2C%20''%2C%20'a%3A10%3A%7Bi%3A1%3Bs%3A0%3A%22%22%3Bi%3A2%3Bs%3A0%3A%22%22%3Bi%3A3%3Bs%3A0%3A%22%22%3Bi%3A4%3Bs%3A0%3A%22%22%3Bi%3A5%3Bs%3A0%3A%22%22%3Bi%3A6%3Bs%3A0%3A%22%22%3Bi%3A7%3Bs%3A0%3A%22%22%3Bi%3A8%3Bs%3A0%3A%22%22%3Bi%3A9%3Bs%3A0%3A%22%22%3Bi%3A10%3Bs%3A0%3A%22%22%3B%7D'%2C%20''%2C%200)%2C%0A%09%09%09%09(8%2C%20''%2C%20''%2C%20''%2C%20''%2C%20'a%3A10%3A%7Bi%3A1%3Bs%3A0%3A%22%22%3Bi%3A2%3Bs%3A0%3A%22%22%3Bi%3A3%3Bs%3A0%3A%22%22%3Bi%3A4%3Bs%3A0%3A%22%22%3Bi%3A5%3Bs%3A0%3A%22%22%3Bi%3A6%3Bs%3A0%3A%22%22%3Bi%3A7%3Bs%3A0%3A%22%22%3Bi%3A8%3Bs%3A0%3A%22%22%3Bi%3A9%3Bs%3A0%3A%22%22%3Bi%3A10%3Bs%3A0%3A%22%22%3B%7D'%2C%20''%2C%200)%2C%0A%09%09%09%09(9%2C%20''%2C%20''%2C%20''%2C%20''%2C%20'a%3A10%3A%7Bi%3A1%3Bs%3A0%3A%22%22%3Bi%3A2%3Bs%3A0%3A%22%22%3Bi%3A3%3Bs%3A0%3A%22%22%3Bi%3A4%3Bs%3A0%3A%22%22%3Bi%3A5%3Bs%3A0%3A%22%22%3Bi%3A6%3Bs%3A0%3A%22%22%3Bi%3A7%3Bs%3A0%3A%22%22%3Bi%3A8%3Bs%3A0%3A%22%22%3Bi%3A9%3Bs%3A0%3A%22%22%3Bi%3A10%3Bs%3A0%3A%22%22%3B%7D'%2C%20''%2C%200)%2C%0A%09%09%09%09(10%2C%20''%2C%20''%2C%20''%2C%20''%2C%20'a%3A10%3A%7Bi%3A1%3Bs%3A0%3A%22%22%3Bi%3A2%3Bs%3A0%3A%22%22%3Bi%3A3%3Bs%3A0%3A%22%22%3Bi%3A4%3Bs%3A0%3A%22%22%3Bi%3A5%3Bs%3A0%3A%22%22%3Bi%3A6%3Bs%3A0%3A%22%22%3Bi%3A7%3Bs%3A0%3A%22%22%3Bi%3A8%3Bs%3A0%3A%22%22%3Bi%3A9%3Bs%3A0%3A%22%22%3Bi%3A10%3Bs%3A0%3A%22%22%3B%7D'%2C%20''%2C%200)%3B");
	}
	

}
