<?php

class Tac_AnyApi_DataWriter_ResponseCache extends XenForo_DataWriter
{

	protected function _getFields()
	{
		return array(
			'sf_anyapi_response_cache' => array(	
				'id'        	  			=> array('type' => self::TYPE_UINT, 'autoIncrement' => true, 'maxLength' => 11),
				'api_request_string' 		=> array('type' => self::TYPE_STRING, 'required' => true),
				'api_response' 				=> array('type' => self::TYPE_STRING, 'required' => false),	
				'time_stamp' 				=> array('type' => self::TYPE_UINT, 'required' => true, 'maxLength' => 11),			
			)
		);
	}

	
	
	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data, 'id'))
		{
			return false;
		}
		return array('sf_anyapi_api_settings' => $this->getModelFromCache('Tac_AnyApi_Model_ResponseCache')->getResponseCacheById($id));
	}

	protected function _getUpdateCondition($tableName)	
	{
		return 'id = ' . $this->_db->quote($this->getExisting('id'));
	}


}