<?php

/**
* DataWriter for the ListingClaim: 
* @package XenForo_Node
*/
class Tac_AnyApi_DataWriter_Log extends XenForo_DataWriter
{

	protected function _getFields()
	{
		return array(
			'sf_anyapi_log' => array(	
				'log_id'        	  		=> array('type' => self::TYPE_UINT,   'autoIncrement' => true, 	'maxLength' => 11),
				'log_date' 					=> array('type' => self::TYPE_UINT,   'default' => 1, 'maxLength' => 10 ),
				'ip_address' 				=> array('type' => self::TYPE_STRING, 'default' => '', ),
				'username'  				=> array('type' => self::TYPE_STRING, 'default' => '', 'maxLength' => 50),
				'email'  					=> array('type' => self::TYPE_STRING, 'default' => '', 'maxLength' => 120),
				'message' 					=> array('type' => self::TYPE_STRING, 'default' => ''),
				'api_request_string'		=> array('type' => self::TYPE_STRING, 'default' => ''),
				'api_response'				=> array('type' => self::TYPE_STRING, 'default' => ''),
				'rules'						=> array('type' => self::TYPE_STRING, 'default' => ''),
				'logic_set'					=> array('type' => self::TYPE_STRING, 'default' => ''),
				'logic_set_bool'			=> array('type' => self::TYPE_STRING, 'default' => ''),
				'is_blocked'				=> array('type' => self::TYPE_UINT,   'default' => 0, 'maxLength' => 1),
				
			)
		);
	}

	
	


	protected function _getExistingData($data)
	{
		if (!$log_id = $this->_getExistingPrimaryKey($data, 'log_id'))
		{
			return false;
		}

		return array('sf_anyapi_log' => $this->getModelFromCache('Tac_AnyApi_Model_Log')->getLogById($log_id));
	}

	protected function _getUpdateCondition($tableName)	
	{
		return 'log_id = ' . $this->_db->quote($this->getExisting('log_id'));
	}


}