<?php

/**
* DataWriter for the ListingClaim: 
* @package XenForo_Node
*/
class Tac_AnyApi_DataWriter_ApiSettings extends XenForo_DataWriter
{


	
	protected function _getFields()
	{
		return array(
			'sf_anyapi_api_settings' => array(	
				'id'        	  			=> array('type' => self::TYPE_UINT, 'autoIncrement' => true, 'maxLength' => 11),
				'name' 						=> array('type' => self::TYPE_STRING, 'required' => false, 'default' => '', 'maxLength' => 30),
				'url' 						=> array('type' => self::TYPE_STRING, 'required' => false, 'default' => ''),	
				'key' 						=> array('type' => self::TYPE_STRING, 'required' => false, 'default' => '', 'maxLength' => 250),
				'data_type' 				=> array('type' => self::TYPE_STRING, 'required' => false, 'default' => '', 'maxLength' => 20),
				'rules' 					=> array('type' => self::TYPE_STRING, 'required' => false, 'default' => ''),
				'logic_set' 				=> array('type' => self::TYPE_STRING, 'required' => false, 'default' => ''),
				'api_active' 				=> array('type' => self::TYPE_UINT, 'required' => true),				
			)
		);
	}

	
	


	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data, 'id'))
		{
			return false;
		}

		return array('sf_anyapi_api_settings' => $this->getModelFromCache('Tac_AnyApi_Model_ApiSettings')->getApiSettingsById($id));
	}

	protected function _getUpdateCondition($tableName)	
	{
		return 'id = ' . $this->_db->quote($this->getExisting('id'));
	}


}