<?php
// If FBHP is installed, use AnyApi there (so API methods + FBHP methods can be used at the same time...  stats)


 
 
class Tac_AnyApi_ControllerPublic_Register extends XFCP_Tac_AnyApi_ControllerPublic_Register
{


	public function actionRegister()
	{
		
		$options = XenForo_Application::get('options');
		$dontCheckApiCaptchFail = $options->aaDontCheckApiCaptchFail;
		

		if($dontCheckApiCaptchFail == 1)
		{		
			$captcha_passed = true;
			if (!XenForo_Captcha_Abstract::validateDefault($this->_input))
			{
				$captcha_passed = false;
			}
			if($captcha_passed == false) 
			{	
				return parent::actionRegister();
			}
		}
		
		$allApiStngs = $this->_getApiSettingsModel()->getApiSettings();	
		$anyApiModel = $this->_getAnyApiModel();
		$isBotAnyApis = array();
		$fields = $anyApiModel->getRealFeildData($this->_input);
		$visibleUsername = (array_key_exists('username', $fields ) ? $fields['username'] : '');
		$visibleEmail = (array_key_exists('email', $fields ) ? $fields['email'] : '');
	
		foreach($allApiStngs as $key=>$apiSettings)
		{	
			$apiNo = 'api_'.$apiSettings['id'];
			$isBotAnyApis[$apiNo] = array('isBot' => $anyApiModel->isAnyApiBot($visibleUsername, $visibleEmail, $this->_input, $apiNo, $apiSettings), 'apiName' => $apiSettings['name']);
		}
		
		$writer = XenForo_DataWriter::create('XenForo_DataWriter_User');
					
		foreach($isBotAnyApis as $key=>$isBotAnyApi)
		{
			if($isBotAnyApi['isBot'] != false)
			{		 
				$writer->error(new XenForo_Phrase('anyapi_sorry_youve_been_detected_against_the_x_database', array('sitedb' => $isBotAnyApi['apiName'])), $key);	
			}			
		}


		$errors = $writer->getErrors();
	
		if ($errors)
		{
			
			$fields['tos'] = $this->_input->filterSingle('agree', XenForo_Input::UINT);
			$customFields = $this->_input->filterSingle('custom_fields', XenForo_Input::ARRAY_SIMPLE);
			$fields['custom_fields'] = $customFields;		
			return $this->_getRegisterFormResponse($fields, $errors);
		}

		return parent::actionRegister();
			
	}

	
	
	

	
	protected function _getApiSettingsModel()
	{
		return $this->getModelFromCache('Tac_AnyApi_Model_ApiSettings');
	}
	
	protected function _getAnyApiModel()
	{
		return $this->getModelFromCache('Tac_AnyApi_Model_AnyApi');
	}
	
		
}