<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Jim Dudek AKA Nhawk/Snog                        # ||
|| # All Rights Reserved.                                             # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # License: NULLXF99999999999                                       # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this file on your server unless       # ||
|| # you have purchased the raffle system from snogssite.com.         # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_Raffles_UnInstall
{
	public static function uninstall()
	{
		$db = XenForo_Application::get('db');
		$db->query("DROP TABLE xf_raffles_entries");
		$db->query("DROP TABLE xf_raffles");
		self::deldir('library/Snog/Raffles');
	}

	public static function deldir($dirPath)
	{
		if (! is_dir($dirPath))
		{
			throw new InvalidArgumentException("$dirPath must be a directory");
		}

		if (substr($dirPath, strlen($dirPath) - 1, 1) != '/')
		{
			$dirPath .= '/';
		}

		$files = glob($dirPath . '*', GLOB_MARK);
		if($files)
		{
			foreach ($files as $file)
			{
				if (is_dir($file)) 
				{
					self::deldir($file);
				}else{
					unlink($file);
				}
			}
		}
		rmdir($dirPath);
	}
}