<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Jim Dudek AKA Nhawk/Snog                        # ||
|| # All Rights Reserved.                                             # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # License: NULLXF99999999999                                       # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this file on your server unless       # ||
|| # you have purchased the raffle system from snogssite.com.         # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_Raffles_Model_Entries extends XenForo_Model
{
	public function getNumberOfEntries($raffleId, $visitorId)
	{
		return $this->_getDb()->fetchOne('SELECT COUNT(*) FROM xf_raffles_entries WHERE raffle_id = ' . $raffleId . ' AND user_id =' . $visitorId);
	}

	public function countDistinctUserEntries($raffleId) 
	{
		return $this->_getDb()->fetchOne('SELECT COUNT(DISTINCT user_id) FROM xf_raffles_entries WHERE raffle_id = ' . $raffleId);
	}

	public function getTotalEntries($raffleId)
	{
		return $this->_getDb()->fetchOne('SELECT COUNT(*) FROM xf_raffles_entries WHERE raffle_id = ' . $raffleId);
	}

	public function getUserEntriesInTimePeriod($raffleId, $visitorId, $maxback)
	{
		return $this->_getDb()->fetchOne('
			SELECT COUNT(*)
			FROM xf_raffles_entries
			WHERE raffle_id = ' . $raffleId . '
			AND user_id = ' . $visitorId . '
			AND timestamp >= ' . $maxback . '
			');
	}

	public function getUserEntries($raffleId)
	{
		return $this->_getDb()->fetchAll('
			SELECT name, xf_raffles.name, xf_user.username, xf_user.user_id
			FROM xf_raffles
			LEFT JOIN xf_raffles_entries
			ON xf_raffles_entries.raffle_id = "' . $raffleId . '"
			LEFT JOIN xf_user
			ON xf_user.user_id = xf_raffles_entries.user_id
			WHERE xf_raffles.raffle_id = "' . $raffleId . '"
			GROUP BY xf_user.username
			ORDER BY xf_user.username ASC
		');
	}

	public function getLastUserEntryByTime($raffleId, $visitorId, $maxback)
	{
		return $this->_getDb()->fetchAll('
			SELECT *
			FROM xf_raffles_entries
			WHERE raffle_id = ' . $raffleId . '
			AND user_id = ' . $visitorId . '
			AND timestamp >= ' . $maxback . '
			ORDER BY timestamp ASC
			LIMIT 1
			');
	}


	public function countEntries($conditions) 
	{
		if($conditions['raffle_name'] && !$conditions['user_id'])
		{
			return $this->_getDb()->fetchOne('
					SELECT COUNT(*)
					FROM xf_raffles
					LEFT JOIN xf_raffles_entries
					ON xf_raffles_entries.raffle_id = xf_raffles.raffle_id
					LEFT JOIN xf_user
					ON xf_user.user_id = xf_raffles_entries.user_id
					WHERE xf_raffles.name LIKE "%' . $conditions['raffle_name'] . '%"
			');
		}else if($conditions['user_id'] && !$conditions['raffle_name']) {
			return $this->_getDb()->fetchOne('
					SELECT COUNT(*)
					FROM xf_raffles_entries
					WHERE xf_raffles_entries.user_id = ' . $conditions['user_id'] . '
			');
		}else if($conditions['user_id'] && $conditions['raffle_name']) {
			return $this->_getDb()->fetchOne('
					SELECT COUNT(*)
					FROM xf_raffles_entries
					LEFT JOIN xf_raffles
					ON xf_raffles.raffle_id = xf_raffles_entries.raffle_id
					WHERE xf_raffles_entries.user_id = ' . $conditions['user_id'] . '
					AND xf_raffles.name LIKE "%' . $conditions['raffle_name'] . '%"
			');
		}else{
			return $this->_getDb()->fetchOne('SELECT COUNT(*) FROM xf_raffles_entries');
		}
	}

	public function getEntriesPaged($fetchOptions, $conditions)
	{
		$limitOptions = $this->prepareLimitFetchOptions($fetchOptions);

		if($conditions['raffle_name'] && !$conditions['user_id'])
		{
				return $this->_getDb()->fetchAll($this->limitQueryResults('
					SELECT name, xf_raffles_entries.entry_id, xf_raffles.raffle_id, xf_user.username, xf_user.user_id, xf_raffles.name
					FROM xf_raffles
					LEFT JOIN xf_raffles_entries
					ON xf_raffles_entries.raffle_id = xf_raffles.raffle_id
					LEFT JOIN xf_user
					ON xf_user.user_id = xf_raffles_entries.user_id
					WHERE xf_raffles.name LIKE "%' . $conditions['raffle_name'] . '%"
					ORDER BY entry_id ASC
					', $limitOptions['limit'], $limitOptions['offset'])
				);
		}else if($conditions['user_id'] && !$conditions['raffle_name']){
				return $this->_getDb()->fetchAll($this->limitQueryResults('
					SELECT name, xf_raffles_entries.entry_id, xf_raffles.raffle_id, xf_user.username, xf_user.user_id, xf_raffles.name
					FROM xf_raffles
					LEFT JOIN xf_raffles_entries
					ON xf_raffles_entries.raffle_id = xf_raffles.raffle_id
					LEFT JOIN xf_user
					ON xf_user.user_id = xf_raffles_entries.user_id
					WHERE xf_raffles_entries.user_id = ' . $conditions['user_id'] . '
					ORDER BY entry_id ASC
					', $limitOptions['limit'], $limitOptions['offset'])
				);
		}else if($conditions['user_id'] && $conditions['raffle_name']){
				return $this->_getDb()->fetchAll($this->limitQueryResults('
					SELECT name, xf_raffles_entries.entry_id, xf_raffles.raffle_id, xf_user.username, xf_user.user_id, xf_raffles.name
					FROM xf_raffles
					LEFT JOIN xf_raffles_entries
					ON xf_raffles_entries.raffle_id = xf_raffles.raffle_id
					LEFT JOIN xf_user
					ON xf_user.user_id = xf_raffles_entries.user_id
					WHERE xf_raffles_entries.user_id = ' . $conditions['user_id'] . '
					AND xf_raffles.name LIKE "%' . $conditions['raffle_name'] . '%"
					ORDER BY entry_id ASC
					', $limitOptions['limit'], $limitOptions['offset'])
				);
		}else{
				return $this->_getDb()->fetchAll($this->limitQueryResults('
					SELECT entry_id, xf_user.username, xf_user.user_id, xf_raffles.name
					FROM xf_raffles_entries
					LEFT JOIN xf_raffles
					ON xf_raffles.raffle_id = xf_raffles_entries.raffle_id
					LEFT JOIN xf_user
					ON xf_user.user_id = xf_raffles_entries.user_id
					ORDER BY entry_id ASC
					', $limitOptions['limit'], $limitOptions['offset'])
				);
		}
	}
	
	public function payForEntries($raffleId, $userId, $amount, $entrycount)
	{
		if($amount)
		{
			$moneyField = XenForo_Application::getOptions()->raffles_moneyfield;
		
			$this->_getDb()->query(
				'UPDATE xf_user
				SET ' . $moneyField . '=' . $moneyField . ' - ' . $amount.'
				WHERE user_id = ?'		
			, $userId);
		}

		for ($i=1; $i<=$entrycount; $i++)
		{
			$this->_getDb()->query('
				INSERT INTO `xf_raffles_entries`
				(raffle_id, user_id, timestamp)
				VALUES (' . $raffleId . ',' . $userId . ','. time() . ')
			');
		}
		return true;
	}
	
	public function changeDrawDate($raffleId)
	{
		$now = time();
		$month = date("n",$now);
		$day = date("j",$now);
		$year = date("Y",$now);
		$draw_time = date("H:i:s",$now);
		$this->_getDb()->query(
			'UPDATE xf_raffles
			SET draw_timestamp = ' . $now . ',
			draw_month = ' . $month . ',
			draw_day = ' . $day . ',
			draw_year = ' . $year . ',
			drawtime = "' . $draw_time . '",
			stop_timestamp = ' . $now . ',
			stop_month = ' . $month . ',
			stop_day = ' . $day . ',
			stop_year = ' . $year . ',
			lasttime = "' . $draw_time . '",
			maxreached = "1"		
			WHERE raffle_id = ?'		
		, $raffleId);

		return true;
	}

	public function getMoney($userId)
	{
		$moneyField = XenForo_Application::getOptions()->raffles_moneyfield;
	
		$user = $this->_getDb()->fetchRow('
			SELECT *
			FROM xf_user
			WHERE user_id = ?
		', $userId);
	
		return $user[$moneyField];
	}
	
	public function getEntry($entryId)
	{
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM xf_raffles_entries
			WHERE entry_id = ?
		', $entryId);
	}

	public function refundPayment($entryId)
	{
		$moneyField = XenForo_Application::getOptions()->raffles_moneyfield;

		if($moneyField)
		{
			$entryinfo = $this->_getDb()->fetchRow('
				SELECT raffle_id, user_id
				FROM xf_raffles_entries
				WHERE entry_id = ?
			', $entryId);

			$raffleinfo = $this->_getDb()->fetchRow('
				SELECT cost
				FROM xf_raffles
				WHERE raffle_id = ?
			', $entryinfo['raffle_id']);

			$amount = $raffleinfo['cost'];

			if($amount)
			{
				$this->_getDb()->query(
					'UPDATE xf_user
					SET ' . $moneyField . '=' . $moneyField . ' + ' . $amount.'
					WHERE user_id = ?'		
				, $entryinfo['user_id']);
			}
		}
	}

	public function entryDelete($entryId)
	{
		$affected = $this->_getDb()->query('
			DELETE FROM xf_raffles_entries
			WHERE entry_id = ?', $entryId);
	}
}