<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Jim Dudek AKA Nhawk/Snog                        # ||
|| # All Rights Reserved.                                             # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # License: NULLXF99999999999                                       # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this file on your server unless       # ||
|| # you have purchased the raffle system from snogssite.com.         # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_Raffles_Install
{
	public static function install()
	{
		$db = XenForo_Application::get('db');
				
		$db->query("
		CREATE TABLE IF NOT EXISTS `xf_raffles` (
			`raffle_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
			`name` varchar(255) NOT NULL,
			`description` longtext NOT NULL,
			`rules` longtext NOT NULL,
			`numprizes` int(10) unsigned NOT NULL,
			`insidebar` tinyint(1) unsigned NOT NULL,
			`showclock` tinyint(1) unsigned NOT NULL,
			`clocktype` tinyint(1) unsigned NOT NULL,
			`clockdays` smallint(2) unsigned NOT NULL,
			`image` varchar(255) NOT NULL,
			`cost` int(10) unsigned NOT NULL,
			`start_month` tinyint(3) unsigned NOT NULL,
			`start_day` tinyint(3) unsigned NOT NULL,
			`start_year` smallint(4) unsigned NOT NULL,
			`start_timestamp` int(10) unsigned NOT NULL,
			`draw_month` tinyint(3) unsigned NOT NULL,
			`draw_day` tinyint(3) unsigned NOT NULL,
			`draw_year` smallint(4) unsigned NOT NULL,
			`drawtime` time NOT NULL,
			`draw_timestamp` int(10) unsigned NOT NULL,
			`stop_month` tinyint(3) unsigned NOT NULL,
			`stop_day` tinyint(3) unsigned NOT NULL,
			`stop_year` smallint(4) unsigned NOT NULL,
			`lasttime` time NOT NULL,
			`stop_timestamp` int(10) unsigned NOT NULL,
			`usergroups` varbinary(255) NOT NULL,
			`badusergroups` varbinary(255) NOT NULL,
			`entries` int(10) unsigned NOT NULL,
			`grouplimits` varchar(255) NOT NULL,
			`timeperiod` int(10) unsigned NOT NULL,
			`intime` int(10) unsigned NOT NULL,
			`rafflemax` int(10) unsigned NOT NULL,
			`maxreached` tinyint(1) NOT NULL,
			`multiple` tinyint(1) NOT NULL,
			`messages` int(10) NOT NULL,
			`inthread` tinyint(1) NOT NULL,
			`node_id` int(10) NOT NULL,
			`posterid` int(10) NOT NULL,
			`tsubject` varchar(150) NOT NULL,
			`tcontent` longtext NOT NULL,
			`custpm` tinyint(1) NOT NULL,
			`pmid` int(10) NOT NULL,
			`psubject` varchar(150) NOT NULL,
			`pcontent` longtext NOT NULL,
			`winner` varchar(255) NOT NULL,
			PRIMARY KEY (`raffle_id`),
			KEY `draw_timestamp` (`draw_timestamp`)
		) ENGINE=InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci;");
		
		$db->query("
		CREATE TABLE IF NOT EXISTS `xf_raffles_entries` (
		  `entry_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
		  `raffle_id` int(10) unsigned NOT NULL,
		  `user_id` int(10) unsigned NOT NULL,
		  `timestamp` int(10) NOT NULL,
		  PRIMARY KEY (`entry_id`)
		) ENGINE=InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci;");

		$db->query("ALTER TABLE `xf_raffles` 
			MODIFY `winner` text NOT NULL");

		// VERSION 1.1.2 - ANNOUNCEMENT FOR EACH RAFFLE
		if (!self::checkExist('xf_raffles','announce'))
		{
			$db = XenForo_Application::get('db');
			$db->query("ALTER TABLE `xf_raffles` 
				ADD `announce` tinyint(1) UNSIGNED NOT NULL,
				ADD `announce_node_id` int(10) UNSIGNED NOT NULL,
				ADD `announce_posterid` int(10) UNSIGNED NOT NULL,
				ADD `announce_tsubject` varchar(150) NOT NULL COLLATE utf8_general_ci,
				ADD `announce_tcontent` longtext NOT NULL COLLATE utf8_general_ci");
		}

		// VERSION 1.1.4 - MARK AS ANNOUNCED
		if (!self::checkExist('xf_raffles','announced'))
		{
			$db = XenForo_Application::get('db');
			$db->query("ALTER TABLE `xf_raffles` 
				ADD `announced` tinyint(1) UNSIGNED NOT NULL");
		}
	}

	public static function checkExist($table, $field)
	{
		$db = XenForo_Application::get('db');
		if ($db->fetchRow('SHOW columns FROM `' . $table . '` WHERE Field = ?', $field)) {
			return true;
		}else{
			return false;
		}
	}
}