<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Jim Dudek AKA Nhawk/Snog                        # ||
|| # All Rights Reserved.                                             # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # License: NULLXF99999999999                                       # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this file on your server unless       # ||
|| # you have purchased the raffle system from snogssite.com.         # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_Raffles_Helper_Raffles
{
	public static function helperRaffles()
	{
		$raffleModel = XenForo_Model::create('Snog_Raffles_Model_Raffle');
		$ActiveRaffles = $raffleModel->getSidebarActiveRaffles(time());
		$raffle_count = 0;
		$clock_id = 0;
		foreach ($ActiveRaffles as &$raffle)
		{
			$raffle['clockid'] = -1;
			$target =  XenForo_Application::getOptions()->raffles_sidebar_size;
			$picturesize = getimagesize($raffle['image']); 
			if($picturesize[0] > $picturesize[1])
			{ 
				$percentage = ($target / $picturesize[0]); 
			}else{ 
				$percentage = ($target / $picturesize[1]); 
			} 
			$raffle['picture_width'] = round($picturesize[0] * $percentage); 
			$raffle['picture_height'] = round($picturesize[1] * $percentage); 
			$formatter = XenForo_BbCode_Formatter_Base::create();
			$parser = new XenForo_BbCode_Parser($formatter);
			$raffle['description'] = $parser->render($raffle['description']); 
			$raffle['description'] = XenForo_Helper_String::wholeWordTrim($raffle['description'], XenForo_Application::getOptions()->raffles_node_preview);
			if($raffle['showclock'] && ($raffle['stop_timestamp'] - time()) <= ($raffle['clockdays'] * 86400) && $clock_id < 9)
			{
				$raffle['day'] = date('d',$raffle['stop_timestamp']);
				$raffle['month'] = date('m',$raffle['stop_timestamp']);
				$raffle['year'] = date('Y',$raffle['stop_timestamp']);
				$raffle['hour'] = date('H',$raffle['stop_timestamp']);
				$raffle['minute'] = date('i',$raffle['stop_timestamp']);
				$raffle['second'] = date('s',$raffle['stop_timestamp']);
				$raffle['dnow']  = date("m/d/Y G:i:s", time());
				$raffle['ctype']  = $raffle['clocktype'];
				$raffle['clockid'] = $clock_id;
				$clock_id++;
			}
			if(XenForo_Application::$externalDataUrl <> 'data') $raffle['image'] = str_replace('data',XenForo_Application::$externalDataUrl,$raffle['image']);
			$raffle_count++;
			$raffle['countid'] = $raffle_count;
		}
		return $ActiveRaffles;
	}
}