<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Jim Dudek AKA Nhawk/Snog                        # ||
|| # All Rights Reserved.                                             # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # License: NULLXF99999999999                                       # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this file on your server unless       # ||
|| # you have purchased the raffle system from snogssite.com.         # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_Raffles_DataWriter_Raffle extends XenForo_DataWriter
{
	protected function _getFields()
	{
		return array(
			'xf_raffles' => array(
				'raffle_id'	=> array('type' => self::TYPE_UINT, 'autoIncrement' => true),
				'name'	=> array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 60, 'requiredError' => 'please_enter_valid_raffle_name'),
				'description'	=> array('type' => self::TYPE_STRING, 'required' => true, 'requiredError' => 'please_enter_raffle_description'),
				'rules'	=> array('type' => self::TYPE_STRING, 'required' => false),
				'numprizes'=> array('type' => self::TYPE_UINT, 'required' => false),
				'image'	=> array('type' => self::TYPE_STRING, 'required' => false, 'maxLength' => 250),
				'insidebar'=> array('type' => self::TYPE_UINT, 'required' => false),
				'showclock'=> array('type' => self::TYPE_UINT, 'required' => false),
				'clocktype'=> array('type' => self::TYPE_UINT, 'required' => false),
				'clockdays'=> array('type' => self::TYPE_UINT, 'required' => false),
				'cost'=> array('type' => self::TYPE_UINT, 'required' => false),
				'start_month'=> array('type' => self::TYPE_UINT, 'required' => true, 'verification' => array('$this', '_verifyStartMonth')),
				'start_day'=> array('type' => self::TYPE_UINT, 'required' => true),
				'start_year'=> array('type' => self::TYPE_UINT, 'required' => true),
				'start_timestamp'=> array('type' => self::TYPE_UINT, 'required' => false),
				'stop_month'=> array('type' => self::TYPE_UINT, 'required' => true, 'verification' => array('$this', '_verifyStopMonth')),
				'stop_day'=> array('type' => self::TYPE_UINT, 'required' => true),
				'stop_year'=> array('type' => self::TYPE_UINT, 'required' => true),
				'lasttime'	=> array('type' => self::TYPE_STRING, 'required' => true),
				'stop_timestamp'=> array('type' => self::TYPE_UINT, 'required' => false),
				'draw_month'=> array('type' => self::TYPE_UINT, 'required' => true, 'verification' => array('$this', '_verifyDrawMonth')),
				'draw_day'=> array('type' => self::TYPE_UINT, 'required' => true),
				'draw_year'=> array('type' => self::TYPE_UINT, 'required' => true),
				'drawtime'	=> array('type' => self::TYPE_STRING, 'required' => true),
				'draw_timestamp'=> array('type' => self::TYPE_UINT, 'required' => false),
				'entries'=> array('type' => self::TYPE_UINT, 'required' => false),
				'grouplimits'=> array('type' => self::TYPE_STRING, 'required' => false),
				'timeperiod'=> array('type' => self::TYPE_UINT, 'required' => false),
				'intime'=> array('type' => self::TYPE_UINT, 'required' => false),
				'rafflemax'=> array('type' => self::TYPE_UINT, 'required' => false),
				'maxreached'=> array('type' => self::TYPE_UINT, 'required' => false, 'default' => '0'),
				'usergroups'	=> array('type' => self::TYPE_BINARY, 'required' => true, 'requiredError' => 'please_select_one_raffle_group'),
				'badusergroups'	=> array('type' => self::TYPE_BINARY, 'required' => false),
				'multiple'	=> array('type' => self::TYPE_UINT, 'required' => false),
				'messages'	=> array('type' => self::TYPE_UINT, 'required' => false),
				'announce'	=> array('type' => self::TYPE_UINT, 'required' => false),
				'announce_node_id'	=> array('type' => self::TYPE_UINT, 'required' => false),
				'announce_posterid'	=> array('type' => self::TYPE_UINT, 'required' => false),
				'announce_tsubject'	=> array('type' => self::TYPE_STRING, 'required' => false, 'maxLength' => 150),
				'announce_tcontent'	=> array('type' => self::TYPE_STRING, 'required' => false),
				'announced'	=> array('type' => self::TYPE_UINT, 'required' => false),
				'inthread'	=> array('type' => self::TYPE_UINT, 'required' => false),
				'node_id'	=> array('type' => self::TYPE_UINT, 'required' => false),
				'posterid'	=> array('type' => self::TYPE_UINT, 'required' => false),
				'tsubject'	=> array('type' => self::TYPE_STRING, 'required' => false, 'maxLength' => 150),
				'tcontent'	=> array('type' => self::TYPE_STRING, 'required' => false),
				'custpm'	=> array('type' => self::TYPE_UINT, 'required' => false),
				'pmid'	=> array('type' => self::TYPE_UINT, 'required' => false),
				'psubject'	=> array('type' => self::TYPE_STRING, 'required' => false, 'maxLength' => 150),
				'pcontent'	=> array('type' => self::TYPE_STRING, 'required' => false),
				'winner'=> array('type' => self::TYPE_STRING, 'required' => false, 'default' => '')
			)
		);
	}

	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data, 'raffle_id'))
		{
			return false;
		}
		return array('xf_raffles' => $this->getModelFromCache('Snog_Raffles_Model_Raffle')->getRaffle($id));
	}

	protected function _getUpdateCondition($tableName)
	{
		return 'raffle_id = ' . $this->_db->quote($this->getExisting('raffle_id'));
	}
	
	protected function _postDelete(){
		$this->getModelFromCache('Snog_Raffles_Model_Raffle')->raffleDelete($this->get('raffle_id'));
	}

	protected function _verifyStartMonth(&$value)
	{
		if(!$value)
		{
			$this->error(new XenForo_Phrase('please_enter_raffle_start_month'), 'start_year');
			return false;
		}
		return true;
	}

	protected function _verifyDrawMonth(&$value)
	{
		if(!$value)
		{
			$this->error(new XenForo_Phrase('please_enter_raffle_draw_month'), 'draw_year');
			return false;
		}
		return true;
	}

	protected function _verifyStopMonth(&$value)
	{
		if(!$value)
		{
			$this->error(new XenForo_Phrase('please_enter_raffle_stop_month'), 'stop_year');
			return false;
		}
		return true;
	}
}
