<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Jim Dudek AKA Nhawk/Snog                        # ||
|| # All Rights Reserved.                                             # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # License: NULLXF99999999999                                       # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this file on your server unless       # ||
|| # you have purchased the raffle system from snogssite.com.         # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_Raffles_ControllerPublic_History extends XenForo_ControllerPublic_Abstract
{	
	public function actionIndex()
	{
		$visitor = XenForo_Visitor::getInstance();
		
		if (!$visitor->hasPermission('raffles', 'viewRaffles'))
		{
			return $this->responseNoPermission();
		}
		
		$admin_timezone = $this->_getUserModel()->getUserById(XenForo_Application::getOptions()->raffles_raffle_admin);
		date_default_timezone_set($admin_timezone['timezone']);
		$raffles = $this->_getRafflesRaffleModel()->getOldRaffles(time(),$visitor);
		$oldcount = 0;

		foreach ($raffles as &$raffle){
			if($raffle['stop_timestamp'] <= time() && !$raffle['winner']) $raffle['waiting'] = true;
			if($raffle['winner']) $raffle['drawn'] = true;
			$raffle['description'] = XenForo_Helper_String::wholeWordTrim($raffle['description'], XenForo_Application::getOptions()->raffles_preview_length);
			$formatter = XenForo_BbCode_Formatter_Base::create();
			$parser = new XenForo_BbCode_Parser($formatter);
			$raffle['description'] = $parser->render($raffle['description']); 
			if(XenForo_Application::$externalDataUrl <> 'data') $raffle['image'] = str_replace('data',XenForo_Application::$externalDataUrl,$raffle['image']);
			$oldcount++;
		}

		if(!$oldcount) $raffles['none'] = true;
		$viewParams = array(
			'raffles' => $raffles,
			'currency' => XenForo_Application::getOptions()->raffles_currency
		);
		
		return $this->responseView('Snog_Raffles_ViewPublic_History', 'raffles_history', $viewParams);
	}

	protected function _getRafflesRaffleModel()
	{
		return $this->getModelFromCache('Snog_Raffles_Model_Raffle');
	}
	
	public static function getSessionActivityDetailsForList(array $activities)
	{
		return new XenForo_Phrase('raffles_viewing_history');
	}

	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	}
}