<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Jim Dudek AKA Nhawk/Snog                        # ||
|| # All Rights Reserved.                                             # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # License: NULLXF99999999999                                       # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this file on your server unless       # ||
|| # you have purchased the raffle system from snogssite.com.         # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_Raffles_ControllerPublic_Details extends XenForo_ControllerPublic_Abstract
{
	public function actionIndex()
	{
		$visitor = XenForo_Visitor::getInstance();
		if (!$visitor->hasPermission('raffles', 'viewRaffles')) return $this->responseNoPermission();
		$admin_timezone = $this->_getUserModel()->getUserById(XenForo_Application::getOptions()->raffles_raffle_admin);
		date_default_timezone_set($admin_timezone['timezone']);
		$raffleId = $this->_input->filterSingle('raffle_id', XenForo_Input::UINT);
		$raffle = $this->_getRafflesRaffleModel()->getRaffle($raffleId);
		if(!$raffle) return $this->responseError(new XenForo_Phrase('raffles_raffle_notfound'));
		$current_model = $this->_getRafflesEntriesModel();
		$cash_on_hand = 0;
		if(XenForo_Application::getOptions()->raffles_moneyfield) $cash_on_hand = $current_model->getMoney($visitor['user_id']);
		$total_user_entries = $current_model->getNumberOfEntries($raffleId,$visitor['user_id']);
		$total_raffle_entries = $current_model->getTotalEntries($raffleId);
		$error_msg = '';
		$notice_msg = '';

		// CHECK FOR DIFFERENT USERGROUP LIMITS
		if($raffle['grouplimits'])
		{
			// BUILD DIFFERENT LIMIT USERGROUP ARRAY
			$firststage = explode(',',$raffle['grouplimits']);
			$check_group = '';

			foreach($firststage as $key=>$stage)
			{
				$secondstage = explode('|',$stage);

				if($check_group)
				{
					$check_group .= ',' . $secondstage[0];
				}else{
					$check_group = $secondstage[0];
				}
			}

			foreach($firststage as $key=>$stage)
			{
				$secondstage = explode('|',$stage);
				if($this->is_a_rafflegroup($secondstage[0],$raffle['usergroups']) && $this->is_in_group($visitor,$check_group)) $raffle['entries'] = $secondstage[1];
			}
		}

		// CHECK IF WINNER HAS BEEN DRAWN 
		if($raffle['winner']) $error_msg = new XenForo_Phrase('raffles_winner_drawn');

		// CHECK ENTRY PERIOD HAS EXPIRED 
		if($raffle['stop_timestamp'] <= time() && !$error_msg) $error_msg = new XenForo_Phrase('raffles_waiting');

		// CHECK IF MAXIMUM ENTRIES RECEIVED 
		if($raffle['rafflemax'] && $total_raffle_entries >= $raffle['rafflemax'] && !$error_msg) $error_msg = new XenForo_Phrase('raffles_max_entries_received');

		// CHECK IF USER CAN ENTER
		if((!$this->is_in_group($visitor,$raffle['usergroups']) || $this->is_in_group($visitor,$raffle['badusergroups']) || $visitor['user_state'] <> 'valid') && !$error_msg) $error_msg = new XenForo_Phrase('raffles_not_allowed');

		// CHECK MESSAGE COUNT 
		if($visitor['message_count'] < $raffle['messages'] && !$error_msg) $error_msg = new XenForo_Phrase('raffles_short_posts');

		// CHECK IF MAXIUM USER ENTRIES REACHED
		if($total_user_entries >= $raffle['entries'] && !$error_msg) $error_msg = new XenForo_Phrase('raffles_max_entries_reached');

		// DECODE TIME PERIOD FOR ENTRY LIMIT
		if($raffle['timeperiod'] && $raffle['intime'])
		{
			$time_length = $raffle['timeperiod'];
			$days_text = '';
			$hours_text = '';
			$minutes_text = '';
			$seconds_text = '';
			$time_message = '';
			$days = intval(floor($time_length / 86400)); 
			$time_length = $time_length % 86400; 
			$hours = intval(floor($time_length / 3600)); 
			$time_length = $time_length % 3600; 
			$minutes = intval(floor($time_length / 60)); 
			$seconds = $time_length % 60; 

			if($minutes == 60)
			{ 
				$hours = $hours+1; 
				$minutes = 0; 
			}

			if($days > 1) 
			{
				$day_text = new XenForo_Phrase('days');
			}else{
				$day_text = new XenForo_Phrase('day');
			}

			if($hours > 1) 
			{
				$hours_text = new XenForo_Phrase('hours');
			}else{
				$hours_text = new XenForo_Phrase('raffles_hour');
			}

			if($minutes > 1) 
			{
				$minutes_text = new XenForo_Phrase('raffles_minutes');
			}else{
				$minutes_text = new XenForo_Phrase('raffles_minute');
			}

			if($seconds > 1) 
			{
				$seconds_text = new XenForo_Phrase('raffles_seconds');
			}else{
				$seconds_text = new XenForo_Phrase('raffles_second');
			}

			if($days > 0) $time_message .= $days . ' ' . $day_text . " ";
			if($hours > 0) $time_message .= $hours . ' ' . $hours_text . " ";
			if($minutes > 0) $time_message .= $minutes . ' ' . $minutes_text . " ";
			if($seconds > 0 && $days == 0 && $hours == 0 && $minutes == 0) $time_message .=  $seconds . ' ' . $seconds_text;
			$raffle['time_decoded'] = $time_message;
		}

		// CHECK IF MAXIUM ENTRIES REACHED IN TIME PERIOD
		$timed_entry_count = 0;
		if($raffle['timeperiod'] && $total_user_entries > 0 && !$error_msg)
		{
			$maxback = time() - $raffle['timeperiod'];
			$timed_entry_count = $current_model->getUserEntriesInTimePeriod($raffleId,$visitor['user_id'],$maxback);

			if($timed_entry_count >= $raffle['intime'])
			{
				$last_entries = $current_model->getLastUserEntryByTime($raffleId,$visitor['user_id'],$maxback);

				foreach ($last_entries as &$last_entry)
				{
					$time_length = ($last_entry['timestamp'] + $raffle['timeperiod']) - time();
				}

				$days_text = '';
				$hours_text = '';
				$minutes_text = '';
				$seconds_text = '';
				$time_message = '';
				$days = intval(floor($time_length / 86400)); 

				if($days > 1) 
				{
					$day_text = new XenForo_Phrase('days');
				}else{
					$day_text = new XenForo_Phrase('day');
				}

				$time_length = $time_length % 86400; 
				$hours = intval(floor($time_length / 3600)); 
				$time_length = $time_length % 3600; 
				$minutes = intval(floor($time_length / 60)); 
				$seconds = $time_length % 60; 

				if($minutes == 60)
				{ 
					$hours = $hours+1; 
					$minutes = 0; 
				}

				if($days > 1) 
				{
					$day_text = new XenForo_Phrase('days');
				}else{
					$day_text = new XenForo_Phrase('day');
				}

				if($hours > 1) 
				{
					$hours_text = new XenForo_Phrase('hours');
				}else{
					$hours_text = new XenForo_Phrase('raffles_hour');
				}
 
				if($minutes > 1) 
				{
					$minutes_text = new XenForo_Phrase('raffles_minutes');
				}else{
					$minutes_text = new XenForo_Phrase('raffles_minute');
				}

				if($seconds > 1) 
				{
					$seconds_text = new XenForo_Phrase('raffles_seconds');
				}else{
					$seconds_text = new XenForo_Phrase('raffles_second');
				}

				if($days > 0) $time_message .= $days . ' ' . $day_text . " ";
				if($hours > 0) $time_message .= $hours . ' ' . $hours_text . " ";
				if($minutes > 0) $time_message .= $minutes . ' ' . $minutes_text . " ";
				if($seconds > 0 && $days == 0 && $hours == 0 && $minutes == 0) $time_message .=  $seconds . ' ' . $seconds_text;
				if($seconds > 0 && $minutes == 1) $time_message .=  $seconds . ' ' . $seconds_text;

				if($total_user_entries > 1)
				{
					$error_msg = new XenForo_Phrase('raffles_have_entered_times', array('times' => $total_user_entries)) . '<br />';
				}else{
					$error_msg = new XenForo_Phrase('raffles_have_entered_time', array('times' => $total_user_entries)) . '<br />';
				}

				$error_msg .= new XenForo_Phrase('raffles_mustwait', array('time_message' => $time_message));
			}
		}

		// CHECK IF CASH IS AVAILABLE TO PURCHASE ENTRY
		if($cash_on_hand < $raffle['cost'] && !$error_msg) $error_msg = new XenForo_Phrase('raffles_not_enough_cash');

		// ESTABLISH HOW MANY ENTRIES THE USER HAS LEFT
		$calc_entries = 0;
		if($raffle['entries'] > $total_user_entries) $calc_entries = $raffle['entries'] - $total_user_entries;
		if($timed_entry_count) $calc_entries = $calc_entries - $timed_entry_count;
		if($calc_entries >= $raffle['intime']) $calc_entries = $raffle['intime'] - $timed_entry_count;
		if(($calc_entries * $raffle['cost']) > $cash_on_hand && $raffle['cost']) $calc_entries = floor($cash_on_hand / $raffle['cost']);
		if($raffle['cost']) $able_to_purchase_entries = floor($cash_on_hand / $raffle['cost']);

		if(!$error_msg)
		{
			$raffle['possible'] = $calc_entries;

			if($total_user_entries)
			{
				if($total_user_entries > 1)
				{
					$notice_msg = new XenForo_Phrase('raffles_have_entered_times', array('times' => $total_user_entries)) . '<br />';
				}else{
					$notice_msg = new XenForo_Phrase('raffles_have_entered_time', array('times' => $total_user_entries)) . '<br />';
				}
			}

			if($raffle['cost'] && $calc_entries > 0 && $able_to_purchase_entries) 
			{
				if($able_to_purchase_entries > 1)
				{
					$notice_msg .= new XenForo_Phrase('raffles_cash_x_times', array('numentries' => $able_to_purchase_entries)) . '<br />';
				}else{
					$notice_msg .= new XenForo_Phrase('raffles_cash_x_time', array('numentries' => $able_to_purchase_entries)) . '<br />';
				}
			}

			if($raffle['timeperiod'] && $calc_entries > 0 && $timed_entry_count == 0) 
			{
				if($calc_entries > 1)
				{
					$notice_msg .= new XenForo_Phrase('raffles_may_enter_times', array('numentries' => $calc_entries)) . '<br />';
				}else{
					$notice_msg .= new XenForo_Phrase('raffles_may_enter_time', array('numentries' => $calc_entries)) . '<br />';
				}
			}

			if($calc_entries > 0 && $timed_entry_count) 
			{
				if($raffle['possible'] > 1)
				{
					$notice_msg .= new XenForo_Phrase('raffles_possible_entries', array('numentries' => $raffle['possible'])) . '<br />';
				}else{
					$notice_msg .= new XenForo_Phrase('raffles_possible_entry', array('numentries' => $raffle['possible'])) . '<br />';
				}
			}

			if(!$raffle['timeperiod'] && $calc_entries > 0 && $raffle['intime'] > 1 && $total_user_entries)
			{
				if($calc_entries > 1)
				{
					$notice_msg .= new XenForo_Phrase('raffles_may_enter_noperiod_times', array('numentries' => $calc_entries)) . '<br />';
				}else{
					$notice_msg .= new XenForo_Phrase('raffles_may_enter_noperiod_time', array('numentries' => $calc_entries)) . '<br />';
				}
			}

			if(!$raffle['timeperiod'] && $calc_entries > 0 && $raffle['intime'] > 1 && !$total_user_entries)
			{
				if($calc_entries > 1)
				{
					$notice_msg .= new XenForo_Phrase('raffles_may_enter_noentries_times', array('numentries' => $calc_entries)) . '<br />';
				}else{
					$notice_msg .= new XenForo_Phrase('raffles_may_enter_noentries_time', array('numentries' => $calc_entries)) . '<br />';
				}
			}
		}

		if($raffle['stop_timestamp'] <= time() && !$raffle['winner']) $raffle['waiting'] = true;
		if($raffle['winner']) $raffle['drawn'] = true;
		$formatter = XenForo_BbCode_Formatter_Base::create();
		$parser = new XenForo_BbCode_Parser($formatter);
		$raffle['description'] = $parser->render($raffle['description']); 
		$raffle['rules'] = $parser->render($raffle['rules']); 
		if(XenForo_Application::$externalDataUrl <> 'data') $raffle['image'] = str_replace('data',XenForo_Application::$externalDataUrl,$raffle['image']);

		$viewParams = array(
			'raffle' => $raffle,
			'error_msg' => $error_msg,
			'notice_msg' => $notice_msg,
			'currency' => XenForo_Application::getOptions()->raffles_currency
		);

		return $this->responseView('Snog_Raffles_ViewPublic_Index', 'raffles_detail', $viewParams);
	}

	public function actionEnter()
	{
		$this->_assertPostOnly();
		$visitor = XenForo_Visitor::getInstance();
		if (!$visitor->hasPermission('raffles', 'viewRaffles')) return $this->responseNoPermission();
		$visitor = XenForo_Visitor::getInstance();
		$admin_timezone = $this->_getUserModel()->getUserById(XenForo_Application::getOptions()->raffles_raffle_admin);
		date_default_timezone_set($admin_timezone['timezone']);
		$raffleId = $this->_input->filterSingle('raffle_id', XenForo_Input::UINT);
		$raffle = $this->_getRafflesRaffleModel()->getRaffle($raffleId);
		if(!$raffle) return $this->responseError(new XenForo_Phrase('raffles_raffle_notfound'));
		$number_entries = $this->_input->filterSingle('raffle_quantity', XenForo_Input::UINT);
		$raffle_agree = $this->_input->filterSingle('raffle_agree', XenForo_Input::UINT);
		$error_msg = '';
		$notice_msg = '';

		// CHECK FOR DIFFERENT USERGROUP LIMITS
		if($raffle['grouplimits'])
		{
			// BUILD DIFFERENT LIMIT USERGROUP ARRAY
			$firststage = explode(',',$raffle['grouplimits']);
			$check_group = '';

			foreach($firststage as $key=>$stage)
			{
				$secondstage = explode('|',$stage);
				if($check_group)
				{
					$check_group .= ',' . $secondstage[0];
				}else{
					$check_group = $secondstage[0];
				}
			}

			foreach($firststage as $key=>$stage)
			{
				$secondstage = explode('|',$stage);
				if($this->is_a_rafflegroup($secondstage[0],$raffle['usergroups']) && $this->is_in_group($visitor,$check_group)) $raffle['entries'] = $secondstage[1];
			}
		}

		if($raffle['rules'] && !$raffle_agree) throw new XenForo_Exception(new XenForo_Phrase('raffles_must_agree'), 'raffle_agree');
		if(!$number_entries && $raffle['intime'] > 1) throw new XenForo_Exception(new XenForo_Phrase('raffles_please_enter'), 'raffle_quantity');
		$visitor_id = $visitor->getUserId();
		$current_model = $this->_getRafflesEntriesModel();
		$cash_on_hand = 0;
		if(XenForo_Application::getOptions()->raffles_moneyfield) $cash_on_hand = $current_model->getMoney($visitor_id);
		$total_user_entries = $current_model->getNumberOfEntries($raffleId,$visitor['user_id']);
		$formatter = XenForo_BbCode_Formatter_Base::create();
		$parser = new XenForo_BbCode_Parser($formatter);
		$raffle['description'] = $parser->render($raffle['description']); 
		$raffle['rules'] = $parser->render($raffle['rules']); 
		$total_raffle_entries = $current_model->getTotalEntries($raffleId);

		// CHECK IF WINNER HAS BEEN DRAWN 
		if($raffle['winner']) $error_msg = new XenForo_Phrase('raffles_winner_drawn');

		// CHECK ENTRY PERIOD HAS EXPIRED 
		if($raffle['stop_timestamp'] <= time() && !$error_msg) $error_msg = new XenForo_Phrase('raffles_waiting');

		// CHECK IF MAXIMUM ENTRIES RECEIVED 
		if($raffle['rafflemax'] && $total_raffle_entries >= $raffle['rafflemax'] && !$error_msg) $error_msg = new XenForo_Phrase('raffles_max_entries_received');

		// CHECK IF USER CAN ENTER
		if((!$this->is_in_group($visitor,$raffle['usergroups']) || $this->is_in_group($visitor,$raffle['badusergroups'])) && !$error_msg) $error_msg = new XenForo_Phrase('raffles_not_allowed');

		// CHECK MESSAGE COUNT 
		if($visitor['message_count'] < $raffle['messages'] && !$error_msg) $error_msg = new XenForo_Phrase('raffles_short_posts');

		// CHECK IF MAXIUM ENTRIES REACHED
		if($total_user_entries >= $raffle['entries'] && !$error_msg) $error_msg = new XenForo_Phrase('raffles_max_entries_reached');

		// CHECK IF MAXIUM ENTRIES REACHED IN TIME PERIOD
		$timed_entry_count = 0;
		if($raffle['timeperiod'] && $total_user_entries > 0 && !$error_msg)
		{
			$maxback = time() - $raffle['timeperiod'];
			$timed_entry_count = $current_model->getUserEntriesInTimePeriod($raffleId,$visitor_id,$maxback);

			if($timed_entry_count >= $raffle['intime'])
			{
				$last_entries = $current_model->getLastUserEntryByTime($raffleId,$visitor_id,$maxback);

				foreach ($last_entries as &$last_entry)
				{
					$time_length = ($last_entry['timestamp'] + $raffle['timeperiod']) - time();
				}

				$days_text = '';
				$hours_text = '';
				$minutes_text = '';
				$seconds_text = '';
				$time_message = '';
				$days = intval(floor($time_length / 86400)); 

				if($days > 1) 
				{
					$day_text = new XenForo_Phrase('days');
				}else{
					$day_text = new XenForo_Phrase('day');
				}

				$time_length = $time_length % 86400; 
				$hours = intval(floor($time_length / 3600)); 
				$time_length = $time_length % 3600; 
				$minutes = intval(floor($time_length / 60)); 
				$seconds = $time_length % 60; 

				if($minutes == 60)
				{ 
					$hours = $hours+1; 
					$minutes = 0; 
				}

				if($days > 1) 
				{
					$day_text = new XenForo_Phrase('days');
				}else{
					$day_text = new XenForo_Phrase('day');
				}

				if($hours > 1) 
				{
					$hours_text = new XenForo_Phrase('hours');
				}else{
					$hours_text = new XenForo_Phrase('raffles_hour');
				}
 
				if($minutes > 1) 
				{
					$minutes_text = new XenForo_Phrase('raffles_minutes');
				}else{
					$minutes_text = new XenForo_Phrase('raffles_minute');
				}

				if($seconds > 1) 
				{
					$seconds_text = new XenForo_Phrase('raffles_seconds');
				}else{
					$seconds_text = new XenForo_Phrase('raffles_second');
				}

				if($days > 0) $time_message .= $days . ' ' . $day_text . " ";
				if($hours > 0) $time_message .= $hours . ' ' . $hours_text . " ";
				if($minutes > 0) $time_message .= $minutes . ' ' . $minutes_text . " ";
				if($seconds > 0 && $days == 0 && $hours == 0 && $minutes == 0) $time_message .=  $seconds . ' ' . $seconds_text;

				if($total_user_entries > 1)
				{
					$error_msg = new XenForo_Phrase('raffles_have_entered_times', array('times' => $total_user_entries)) . '<br />';
				}else{
					$error_msg = new XenForo_Phrase('raffles_have_entered_time', array('times' => $total_user_entries)) . '<br />';
				}

				$error_msg .= new XenForo_Phrase('raffles_mustwait', array('time_message' => $time_message));
			}
		}

		// CHECK IF CASH IS AVAILABLE TO PURCHASE ENTRY
		if($cash_on_hand < $raffle['cost'] && !$error_msg) $error_msg = new XenForo_Phrase('raffles_not_enough_cash');

		// ESTABLISH HOW MANY ENTRIES THE USER HAS LEFT
		$calc_entries = 0;
		if($raffle['entries'] > $total_user_entries) $calc_entries = $raffle['entries'] - $total_user_entries;
		if($timed_entry_count) $calc_entries = $calc_entries - $timed_entry_count;
		if($calc_entries > $raffle['intime']) $calc_entries = $raffle['intime'] - $timed_entry_count;
		if(($calc_entries * $raffle['cost']) > $cash_on_hand && $raffle['cost']) $calc_entries = floor($cash_on_hand / $raffle['cost']);
		if($raffle['cost']) $able_to_purchase_entries = floor($cash_on_hand / $raffle['cost']);
		$raffle['possible'] = $calc_entries;
		if($number_entries > $calc_entries && !$error_msg) $error_msg = new XenForo_Phrase('raffles_over_limit');

		// OK - NO ERRORS - PROCESS THE ENTRIES
		if(!$error_msg)
		{

			if($raffle['rafflemax'] && ($number_entries + $total_raffle_entries) > $raffle['rafflemax']) $number_entries = $raffle['rafflemax'] - $total_raffle_entries;
			$total_raffle_entries = $total_raffle_entries + $number_entries;
			$total_cost = 0;

			if($raffle['cost'] && $number_entries)
			{
				 $total_cost = $number_entries * $raffle['cost'];
			}else if($raffle['cost']){
				 $total_cost = $raffle['cost'];
			}

			if($number_entries)
			{
				$entries_done = $current_model->payForEntries($raffleId,$visitor_id,$total_cost,$number_entries);
			}else{
				$entries_done = $current_model->payForEntries($raffleId,$visitor_id,$total_cost,'1');
			}

			if($raffle['rafflemax'] && $total_raffle_entries >= $raffle['rafflemax']) $change_drawdate = $current_model->changeDrawDate($raffleId);
			if($entries_done) $error_msg = 'Your entry has been recorded';

			$viewParams = array(
				'raffle' => $raffle,
				'currency' => XenForo_Application::getOptions()->raffles_currency,
				'error_msg' => $error_msg,
				'notice_msg' => $notice_msg,
				'cash' => XenForo_Template_Helper_Core::numberFormat($cash_on_hand,0),
				'cashraw' => $cash_on_hand,
			);

			$return = 'index.php?raffles-details/&raffle_id=' . $raffleId;

			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				$return,
				new XenForo_Phrase('raffles_entry_received')
			); 
		}

		if(XenForo_Application::$externalDataUrl <> 'data') $raffle['image'] = str_replace('data',XenForo_Application::$externalDataUrl,$raffle['image']);

		$viewParams = array(
			'raffle' => $raffle,
			'currency' => XenForo_Application::getOptions()->raffles_currency,
			'error_msg' => $error_msg,
			'notice_msg' => $notice_msg,
			'cash' => XenForo_Template_Helper_Core::numberFormat($cash_on_hand,0),
			'cashraw' => $cash_on_hand,
		);

		return $this->responseView('Snog_Raffles_ViewPublic_Index', 'raffles-details', $viewParams);
	}

	public function actionEntries()
	{
		$visitor = XenForo_Visitor::getInstance();
		if (!$visitor->hasPermission('raffles', 'viewRaffleEntries')) return $this->responseNoPermission();
		$raffleId = $this->_input->filterSingle('raffleid', XenForo_Input::UINT);
		$entryModel = $this->_getRafflesEntriesModel();
		$entries = $entryModel->getUserEntries($raffleId);
		$entrycount = $entryModel->getTotalEntries($raffleId);
		$distinct = $entryModel->countDistinctUserEntries($raffleId);

		$viewParams = array(
			'users' => $entries,
			'entrycount' => $entrycount,
			'distinct' => $distinct
		);
		return $this->responseView('XenForo_ViewPublic_Misc_Style', 'raffles_entry_list', $viewParams);
	}

	protected function _getRafflesRaffleModel()
	{
		return $this->getModelFromCache('Snog_Raffles_Model_Raffle');
	}

	protected function _getRafflesEntriesModel()
	{
		return $this->getModelFromCache('Snog_Raffles_Model_Entries');
	}

	public static function getSessionActivityDetailsForList(array $activities)
	{
		return new XenForo_Phrase('raffles_viewing_detail');
	}

	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	}

	public static function is_a_rafflegroup($checkgroups,$rafflegroups)
	{
		if(!$rafflegroups) return false;
		$member_groups = explode(',',$checkgroups);
		$raffle_groups = explode(',',$rafflegroups);

		foreach ($member_groups AS $groupId)
		{
			// IS GROUP IN USERGROUPS
			if (in_array($groupId, $raffle_groups))
			{
				return true;
			}
		}

		// USERGROUP IS OK
		return false;
	}

	public static function is_in_group($visitor,$rafflegroups)
	{
		if(!$rafflegroups) return false;
		$member_secondary_groups = explode(',',$visitor['secondary_group_ids']);
		$raffle_groups = explode(',',$rafflegroups);

		// ADD PRIMARY GROUP TO CHECK
		$member_secondary_groups[] = $visitor['user_group_id'];

		foreach ($member_secondary_groups AS $groupId)
		{
			// IS GROUP IN USERGROUPS
			if (in_array($groupId, $raffle_groups))
			{
				return true;
			}
		}

		// USERGROUP IS OK
		return false;
	}
}