<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Jim Dudek AKA Nhawk/Snog                        # ||
|| # All Rights Reserved.                                             # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # License: NULLXF99999999999                                       # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this file on your server unless       # ||
|| # you have purchased the raffle system from snogssite.com.         # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_Raffles_ControllerAdmin_Raffle extends XenForo_ControllerAdmin_Abstract
{
	protected function _preDispatch($action)
	{
		$this->assertAdminPermission('raffles');
	}

	public function actionIndex()
	{
		$raffles = $this->_getRaffleModel()->getRaffles();
		$viewParams = array('raffles' => $raffles);
		return $this->responseView('Snog_Raffles_ViewAdmin_Index', 'raffles_edit_list', $viewParams);
	}

	public function actionCreate()
	{
		return $this->_getCreateResponse();
	}

	public function actionSave()
	{
		$this->_assertPostOnly();
		$raffle_id = $this->_input->filterSingle('raffle_id', XenForo_Input::UINT);
		$groups = $this->_input->filterSingle('usergroups', XenForo_Input::ARRAY_SIMPLE);
		$badgroups = $this->_input->filterSingle('badusergroups', XenForo_Input::ARRAY_SIMPLE);

		$dwInput = $this->_input->filter(array(
				'name' => XenForo_Input::STRING,
				'description' => XenForo_Input::STRING,
				'rules' => XenForo_Input::STRING,
				'numprizes' => XenForo_Input::UINT,
				'insidebar' => XenForo_Input::UINT,
				'showclock' => XenForo_Input::UINT,
				'clocktype' => XenForo_Input::UINT,
				'clockdays' => XenForo_Input::UINT,
				'image' => XenForo_Input::STRING,
				'cost' => XenForo_Input::UINT,
				'start_month' => XenForo_Input::UINT,
				'start_day' => XenForo_Input::UINT,
				'start_year' => XenForo_Input::UINT,
				'stop_month' => XenForo_Input::UINT,
				'stop_day' => XenForo_Input::UINT,
				'stop_year' => XenForo_Input::STRING,
				'draw_month' => XenForo_Input::UINT,
				'draw_day' => XenForo_Input::UINT,
				'draw_year' => XenForo_Input::UINT,
				'drawtime' => XenForo_Input::STRING,
				'lasttime' => XenForo_Input::STRING,
				'entries' => XenForo_Input::UINT,
				'grouplimits' => XenForo_Input::STRING,
				'timeperiod' => XenForo_Input::UINT,
				'intime' => XenForo_Input::UINT,
				'rafflemax' => XenForo_Input::UINT,
				'multiple' => XenForo_Input::UINT,
				'announce' => XenForo_Input::UINT,
				'announce_node_id' => XenForo_Input::UINT,
				'announce_posterid' => XenForo_Input::UINT,
				'announce_tsubject' => XenForo_Input::STRING,
				'announce_tcontent' => XenForo_Input::STRING,
				'announced' => XenForo_Input::UINT,
				'inthread' => XenForo_Input::UINT,
				'node_id' => XenForo_Input::UINT,
				'posterid' => XenForo_Input::UINT,
				'tsubject' => XenForo_Input::STRING,
				'tcontent' => XenForo_Input::STRING,
				'custpm' => XenForo_Input::UINT,
				'pmid' => XenForo_Input::UINT,
				'psubject' => XenForo_Input::STRING,
				'pcontent' => XenForo_Input::STRING,
				'messages' => XenForo_Input::UINT
		));

		$dw = XenForo_DataWriter::create('Snog_Raffles_DataWriter_Raffle');
		if(!$dwInput['inthread'] && !$dwInput['custpm']) $dw->error(new XenForo_Phrase('raffles_must_notify'), 'custpm');
		if(!$dwInput['image']) $dwInput['image'] = 'data/raffles/images/default.png';
		$admin_timezone = $this->_getUserModel()->getUserById(XenForo_Application::getOptions()->raffles_raffle_admin);
		date_default_timezone_set($admin_timezone['timezone']);
		$dw->set('usergroups', implode(',', $groups));
		$dw->set('badusergroups', implode(',', $badgroups));
		if ($this->_getRaffleModel()->getRaffle($raffle_id)) $dw->setExistingData($raffle_id);
		if($dwInput['intime'] > $dwInput['entries']) $dwInput['intime'] = $dwInput['entries'];		

		// WE MUST CHECK DATE INPUTS FOR ERRORS HERE
		// BECAUSE THEY ARE USED TO CALCULATE OTHER VALUES
		// THAT ARE SET INTO THE DATABASE
		$date_input_error = false;
		$start_input_error = false;
		$stop_input_error = false;
		$draw_input_error = false;

		if($dwInput['start_year'] < '1970' || $dwInput['start_year'] > '2038') 
		{
			$dw->error(new XenForo_Phrase('please_enter_raffle_start_year'), 'start_year');
			$start_input_error = true;
			$date_input_error = true;
		}

		if($dwInput['stop_year'] < '1970' || $dwInput['stop_year'] > '2038') 
		{
			$dw->error(new XenForo_Phrase('please_enter_raffle_stop_year'), 'stop_year');
			$stop_input_error = true;
			$date_input_error = true;
		}

		if($dwInput['draw_year'] < '1970' || $dwInput['draw_year'] > '2038') 
		{
			$dw->error(new XenForo_Phrase('please_enter_raffle_draw_year'), 'draw_year');
			$draw_input_error = true;
			$date_input_error = true;
		}

		if($dwInput['start_month'] && !$start_input_error)
		{
			$days = date('t',strtotime($dwInput['start_month'] . '/01/' . $dwInput['start_year']));
			if($dwInput['start_day'] < 1 || $dwInput['start_day'] > $days)
			{
				$dw->error(new XenForo_Phrase('please_enter_raffle_start_day'), 'start_year');
				$date_input_error = true;
			}
		}

		if($dwInput['stop_month'] && !$stop_input_error)
		{
			$days = date('t',strtotime($dwInput['stop_month'] . '/01/' . $dwInput['stop_year']));
			if($dwInput['stop_day'] < 1 || $dwInput['stop_day'] > $days)
			{
				$dw->error(new XenForo_Phrase('please_enter_raffle_stop_day'), 'stop_year');
				$date_input_error = true;
			}
		}

		if($dwInput['draw_month'] && !$draw_input_error)
		{
			$days = date('t',strtotime($dwInput['draw_month'] . '/01/' . $dwInput['draw_year']));
			if($dwInput['draw_day'] < 1 || $dwInput['draw_day'] > $days)
			{
				$dw->error(new XenForo_Phrase('please_enter_raffle_draw_day'), 'draw_year');
				$date_input_error = true;
			}
		}

		if(!$dwInput['drawtime'] || !strstr($dwInput['drawtime'],':')) 
		{
			$dw->error(new XenForo_Phrase('please_enter_raffle_draw_time'), 'drawtime');
			$date_input_error = true;
		}

		if(!$dwInput['lasttime'] || !strstr($dwInput['lasttime'],':')) 
		{
			$dw->error(new XenForo_Phrase('please_enter_raffle_stop_time'), 'lasttime');
			$date_input_error = true;
		}

		// NO DATE INPUT ERRORS - DO DATE CALCULATIONS
		if(!$date_input_error)
		{
			$start_text_notime = $dwInput['start_month'] . '/' . $dwInput['start_day'] . '/' . $dwInput['start_year'];
			$stop_text_notime = $dwInput['stop_month'] . '/' . $dwInput['stop_day'] . '/' . $dwInput['stop_year'];
			$draw_text_notime = $dwInput['draw_month'] . '/' . $dwInput['draw_day'] . '/' . $dwInput['draw_year'];
			$start_text = $dwInput['start_month'] . '/' . $dwInput['start_day'] . '/' . $dwInput['start_year'];
			$stop_text = $dwInput['stop_month'] . '/' . $dwInput['stop_day'] . '/' . $dwInput['stop_year'] . ' ' . $dwInput['lasttime'];
			$draw_text = $dwInput['draw_month'] . '/' . $dwInput['draw_day'] . '/' . $dwInput['draw_year'] . ' ' . $dwInput['drawtime'];
			if(strtotime($start_text_notime) > strtotime($stop_text_notime)) $dw->error(new XenForo_Phrase('raffles_stop_must_be_greater'), 'stop_year');
			if(strtotime($stop_text_notime) == strtotime($draw_text_notime) && strtotime($dwInput['lasttime']) > strtotime($dwInput['drawtime'])) $dw->error(new XenForo_Phrase('raffles_drawtime_must_be_greater'), 'drawtime');
			if(strtotime($start_text) > strtotime($draw_text))  $dw->error(new XenForo_Phrase('raffles_draw_greater_than_start'), 'draw_year');
			if(strtotime($stop_text) > strtotime($draw_text))  $dw->error(new XenForo_Phrase('raffles_draw_must_be_greater'), 'draw_year');
			$dw->set('start_timestamp', strtotime($start_text));
			$dw->set('stop_timestamp', strtotime($stop_text));
			$dw->set('draw_timestamp', strtotime($draw_text));
		}

		// NEW THREAD CHECKS
		// CHECK IF POSTER ID IS ENTERED FOR NEW THREAD
		if($dwInput['inthread'] && !$dwInput['posterid']) $dw->error(new XenForo_Phrase('raffles_poster_id'), 'posterid');
		if($dwInput['announce'] && !$dwInput['announce_posterid']) $dw->error(new XenForo_Phrase('raffles_poster_id'), 'announce_posterid');

		// CHECK IF SUBJECT IS ENTERED FOR NEW THREAD
		if($dwInput['inthread'] && !$dwInput['tsubject']) $dw->error(new XenForo_Phrase('raffles_enter_title'), 'tsubject');
		if($dwInput['announce'] && !$dwInput['announce_tsubject']) $dw->error(new XenForo_Phrase('raffles_enter_title'), 'announce_tsubject');

		// CHECK IF CONTENT IS ENTERED FOR NEW THREAD
		if($dwInput['inthread'] && !$dwInput['tcontent']) $dw->error(new XenForo_Phrase('raffles_thread_content_error'), 'tcontent');
		if($dwInput['announce'] && !$dwInput['announce_tcontent']) $dw->error(new XenForo_Phrase('raffles_thread_content_error'), 'announce_tcontent');

		// PM CHECKS
		// CHECK IF POSTER ID IS ENTERED FOR PM
		if($dwInput['custpm'] && !$dwInput['pmid']) $dw->error(new XenForo_Phrase('raffles_pmsender_id_error'), 'pmid');

		// CHECK IF SUBJECT IS ENTERED FOR PM
		if($dwInput['custpm'] && !$dwInput['psubject']) $dw->error(new XenForo_Phrase('raffles_pmsubject_error'), 'psubject');

		// CHECK IF CONTENT IS ENTERED FOR PM
		if($dwInput['custpm'] && !$dwInput['pcontent']) $dw->error(new XenForo_Phrase('raffles_pmcontent_error'), 'pcontent');

		if($raffle_id) $dw->set('raffle_id', $raffle_id);
		$announce = false;

		if($dwInput['announce'] && $dwInput['announced'] == 0)
		{
			$announce = true;
			$dwInput['announced'] = 1;
		}

		$dw->bulkSet($dwInput);
		$dw->save();
		if(!$raffle_id) $raffle_id = $dw->get('raffle_id');

		if($dwInput['announce'] && $announce)
		{
			// AND POST NEW RAFFLE MESSAGE IF SELECTED
			$poster_info = $this->_getUserModel()->getUserById($dwInput['announce_posterid']);
			if($dwInput['announce_tsubject']) $thread_subject = str_replace('{1}',$dwInput['name'],$dwInput['announce_tsubject']);

			if($dwInput['announce_tcontent'])
			{
				$thread_message = str_replace('{1}', $dwInput['name'], $dwInput['announce_tcontent']);
				$thread_message = str_replace('{2}', '[URL="' . XenForo_Application::getOptions()->boardUrl . '/index.php?raffles-details/&raffle_id=' . $raffle_id . '"]' . $dwInput['name'] . "[/URL]", $thread_message);
			}

			$pstid = Snog_Raffles_Helper_DataWriter::createThread($poster_info, $dwInput['announce_node_id'], $thread_subject, $thread_message);
		}

		$return = XenForo_Link::buildAdminLink('raffles/' . $raffle_id . '/edit');
		return $this->responseRedirect(XenForo_ControllerResponse_Redirect::SUCCESS,$return);
	}

	public function actionDraw()
	{
		if ($this->isConfirmedPost())
		{
			$admin_timezone = $this->_getUserModel()->getUserById(XenForo_Application::getOptions()->raffles_raffle_admin);
			$raffle_id = $this->_input->filterSingle('raffle_id', XenForo_Input::UINT);
			$raffle = $this->_getRaffleOrError($raffle_id);
			$entries_model = $this->_getRafflesEntriesModel();
			if($raffle['inthread'] && $raffle['posterid']) $poster_info = $this->_getUserModel()->getUserById($raffle['posterid']);
			if($raffle['custpm'] && $raffle['pmid']) $pmauthor_info = $this->_getUserModel()->getUserById($raffle['pmid']);
			$winner_count = 0;
			$entry_count = 0;
			$winner_ids = '';
			$winner_list = '';
			$entry_count = $entries_model->countDistinctUserEntries($raffle['raffle_id']);
			if($entry_count < $raffle['numprizes'] && !$raffle['multiple']) throw new XenForo_Exception(new XenForo_Phrase('raffles_not_able'), true);
		
			while($winner_count < $raffle['numprizes'])
			{
				$winner_draw = $this->_getRaffleModel()->getRaffleWinner($raffle['raffle_id']);

				if(!$raffle['multiple'] && $winner_list)
				{
					while(in_array($winner_draw['user_id'], explode(",",$winner_ids)))
					{
						$winner_draw = $this->_getRaffleModel()->getRaffleWinner($raffle['raffle_id']);
					}
				}

				if(!$winner_draw['user_id'])
				{
					throw new XenForo_Exception(new XenForo_Phrase('raffles_no_winner'), true);
				}else{
					$winner_count = $winner_count + 1;
					$winner = $this->_getUserModel()->getUserById($winner_draw['user_id']);
				}

				if($raffle['numprizes'] == 1 && $winner['user_id'])
				{	
					if(!XenForo_Application::getOptions()->raffles_display_tickets)
					{
						$winner_info = $winner['username'];
					}else{
						$winner_info = $winner['username'] . " (" . new XenForo_Phrase('raffles_ticketnumber') . ": " . $winner_draw['entry_id'] . ")";
					}

					$this->_getRaffleModel()->raffleWinnerUpdate($raffle['raffle_id'],$winner_info);

					if($raffle['inthread'] && $raffle['tsubject'])
					{
						$thread_subject = str_replace('{1}',$raffle['name'],$raffle['tsubject']);
						$thread_subject = str_replace('{2}',$winner['username'],$thread_subject);
					}

					if($raffle['inthread'] && $raffle['tcontent'])
					{
						$thread_message = str_ireplace('{1}', $raffle['name'], $raffle['tcontent']);
						$thread_message = str_ireplace('{2}',$winner['username'],$thread_message);
						$thread_message = str_ireplace('{3}',$admin_timezone['username'],$thread_message);
						$thread_message = str_ireplace('{4}',$poster_info['username'],$thread_message);
					}

					if($raffle['custpm'] && $raffle['psubject'])
					{
						$pm_subject = str_replace('{1}',$raffle['name'],$raffle['psubject']);
					}

					if($raffle['custpm'] && $raffle['pcontent'])
					{
						$pm_message = str_ireplace('{1}', $raffle['name'], $raffle['pcontent']);
						$pm_message = str_ireplace('{2}',$winner['username'],$pm_message);
						$pm_message = str_ireplace('{3}',$admin_timezone['username'],$pm_message);
						$pm_message = str_ireplace('{4}',$pmauthor_info['username'],$pm_message);
					}

					if($raffle['custpm'] && $winner['user_id'] <> $pmauthor_info['user_id'])
					{
						$pmid = Snog_Raffles_Helper_DataWriter::createConversation($pmauthor_info, array($winner['user_id']), $pm_subject, $pm_message);
					}

					if($raffle['inthread'])
					{
						$pstid = Snog_Raffles_Helper_DataWriter::createThread($poster_info, $raffle['node_id'], $thread_subject, $thread_message);
					}

					$winner_list = $winner_info;
				}else{
					if($winner['user_id'])
					{
						if(!XenForo_Application::getOptions()->raffles_display_tickets)
						{
							$winner_info = $winner['username'];
						}else{
							$winner_info = $winner['username'] . " (" . new XenForo_Phrase('raffles_ticketnumber') . ": " . $winner_draw['entry_id'] . ")";
						}

						if($winner_list)
						{
							$winner_list .= ", " . $winner_info;
							$winner_ids .= "," . $winner['user_id'];
						}else{
							$winner_list = $winner_info;
							$winner_ids .= $winner['user_id'];
						}

						if($winner_count == $raffle['numprizes'])
						{
							$this->_getRaffleModel()->raffleWinnerUpdate($raffle['raffle_id'],$winner_list);

							if($raffle['inthread'] && $raffle['tsubject'])
							{
								$thread_subject = str_replace('{1}',$raffle['name'],$raffle['tsubject']);
								$thread_subject = str_replace('{2}',$winner_list,$thread_subject);
							}

							if($raffle['inthread'] && $raffle['tcontent'])
							{
								$thread_message = str_ireplace('{1}', $raffle['name'], $raffle['tcontent']);
								$thread_message = str_ireplace('{2}',$winner_list,$thread_message);
								$thread_message = str_ireplace('{3}',$admin_timezone['username'],$thread_message);
								$thread_message = str_ireplace('{4}',$poster_info['username'],$thread_message);
							}

							if($raffle['inthread'])
							{
								$pstid = Snog_Raffles_Helper_DataWriter::createThread($poster_info, $raffle['node_id'], $thread_subject, $thread_message);
							}
						}

						if($raffle['custpm'] && $raffle['psubject'])
						{
							$pm_subject = str_replace('{1}',$raffle['name'],$raffle['psubject']);
							$pm_subject = str_replace('{2}',$winner['username'],$pm_subject);
						}

						if($raffle['custpm'] && $raffle['pcontent'])
						{
							$pm_message = str_ireplace('{1}', $raffle['name'], $raffle['pcontent']);
							$pm_message = str_ireplace('{2}',$winner['username'],$pm_message);
							$pm_message = str_ireplace('{3}',$admin_timezone['username'],$pm_message);
							$pm_message = str_ireplace('{4}',$pmauthor_info['username'],$pm_message);
						}

						if($raffle['custpm'])
						{
							$pmid = Snog_Raffles_Helper_DataWriter::createConversation($pmauthor_info, array($winner['user_id']), $pm_subject, $pm_message);
						}
					}
				}
			}
			$raffles = $this->_getRaffleModel()->getRaffles();
			$viewParams = array('raffles' => $raffles);
			return $this->responseView('Snog_Raffles_ViewAdmin_Index', 'raffles_edit_list', $viewParams);
		}else{
			$raffle_id = $this->_input->filterSingle('raffle_id', XenForo_Input::UINT);
			$raffle = $this->_getRaffleOrError($raffle_id);
			$viewParams = array('raffle' => $raffle);
			return $this->responseView('Snog_Raffles_ViewAdmin_Raffle_Delete', 'raffles_draw_confirm', $viewParams);
		}
	}

	public function actionUploadimage()
	{
		$raffle_id = $this->_input->filterSingle('raffle_id', XenForo_Input::UINT);
		$raffle = $this->_getRaffleOrError($raffle_id);
		$viewParams = array('raffle' => $raffle);
		return $this->responseView('Snog_Raffles_ViewAdmin_Index', 'raffles_upload_image', $viewParams);
	}

	public function actionSaveimage()
	{
		$raffle_id = $this->_input->filterSingle('raffle_id', XenForo_Input::UINT);
		if($_FILES['upload_file']['name'])
		{
			$filetypes = "jpg,jpeg,jpe,gif,png";
			$filepath = 'data/raffles/images';
			$pos = strrpos($_FILES['upload_file']['name'],'.');

			if($pos == false)
			{
				throw new XenForo_Exception(new XenForo_Phrase('raffles_no_file_extension'), true);
			}else{
				$extension = strtolower(substr($_FILES['upload_file']['name'], $pos + 1));
			}
			if(!in_array($extension,explode(',',strtolower($filetypes))))
			{
				throw new XenForo_Exception(new XenForo_Phrase('raffles_file_type_error'), true);
			}
			$CleanFile = $_FILES['upload_file']['name'];
			$CleanFile = str_replace("#", "_Number_", $CleanFile);
			$CleanFile = str_replace("$", "_Dollar_", $CleanFile);
			$CleanFile = str_replace("%", "_Percent_", $CleanFile);
			$CleanFile = str_replace("^", "", $CleanFile);
			$CleanFile = str_replace("&", "_and_", $CleanFile); 
			$CleanFile = str_replace("*", "", $CleanFile);
			$CleanFile = str_replace("?", "", $CleanFile);
			$filepath .= '/';
			if(!is_dir($filepath))
			{
				mkdir($filepath, 0775, true);
				chmod($filepath, 0775);
				$filehandle = fopen("./" . $filepath . '/index.html', "w");
				fclose($filehandle);
			}
			$uploaddir = $filepath; 
			$path = $uploaddir.$CleanFile; 

			if($CleanFile)
			{
				if(copy($_FILES['upload_file']['tmp_name'], $path))
				{
					$thisFileName = $filepath . $CleanFile;
					$this->_getRaffleModel()->raffleImageUpdate($raffle_id,$thisFileName);			
				}else{
					throw new XenForo_Exception(new XenForo_Phrase('raffles_file_upload_error'), true);
				}
			}
		}

		$raffle = $this->_getRaffleOrError($raffle_id);
		return $this->_getEditResponse($raffle);
	}

	public function actionEdit()
	{
		$raffle_id = $this->_input->filterSingle('raffle_id', XenForo_Input::UINT);
		$raffle = $this->_getRaffleOrError($raffle_id);
		return $this->_getEditResponse($raffle);
	}

	public function actionDelete()
	{
		if ($this->isConfirmedPost())
		{
			$raffle_id = $this->_input->filterSingle('raffle_id', XenForo_Input::UINT);
			$image = $this->_getRaffleModel()->getRaffleImage($raffle_id);
			if($image['image'] <> 'data/raffles/images/default.png' && file_exists($image['image'])) unlink($image['image']);
			return $this->_deleteData('Snog_Raffles_DataWriter_Raffle','raffle_id',XenForo_Link::buildAdminLink('raffles'));
		}else{
			$raffle_id = $this->_input->filterSingle('raffle_id', XenForo_Input::UINT);
			$raffle = $this->_getRaffleOrError($raffle_id);
			$viewParams = array('raffle' => $raffle);
			return $this->responseView('Snog_Raffles_ViewAdmin_Raffle_Delete', 'raffles_edit_delete', $viewParams);
		}
	}

	protected function _getEditResponse($raffle)
	{
		$userGroupOptions = $this->getModelFromCache('XenForo_Model_UserGroup')->getUserGroupOptions(explode(',', $raffle['usergroups']));
		$baduserGroupOptions = $this->getModelFromCache('XenForo_Model_UserGroup')->getUserGroupOptions(explode(',', $raffle['badusergroups']));
		$viewParams = array(
				"groups" => $userGroupOptions,
				"badgroups" => $baduserGroupOptions,
				"raffle" => $raffle,
				'nodeParentOptions' => $this->getModelFromCache('Snog_Raffles_Model_Node')->getRaffleNodeOptions(
					$this->getModelFromCache('XenForo_Model_Node')->getAllNodes(false)),
				'postnodeParentOptions' => $this->getModelFromCache('Snog_Raffles_Model_Node')->getRaffleNodeOptions(
					$this->getModelFromCache('XenForo_Model_Node')->getAllNodes(false))
		);
		return $this->responseView('Snog_Raffles_ViewAdmin_Raffle_Edit', 'raffles_edit_raffle', $viewParams);
	}

	protected function _getCreateResponse()
	{
		$userGroupOptions = $this->_getUserGroupModel()->getAllUserGroupTitles();

		$viewParams = array(
				"groups" => $userGroupOptions,
				"badgroups" => $userGroupOptions,
				'nodeParentOptions' => $this->getModelFromCache('Snog_Raffles_Model_Node')->getRaffleNodeOptions(
					$this->getModelFromCache('XenForo_Model_Node')->getAllNodes(false)),
				'postnodeParentOptions' => $this->getModelFromCache('Snog_Raffles_Model_Node')->getRaffleNodeOptions(
					$this->getModelFromCache('XenForo_Model_Node')->getAllNodes(false))
		);
		return $this->responseView('Snog_Raffles_ViewAdmin_Raffle_Edit', 'raffles_edit_raffle', $viewParams);
	}

	public function actionWinners()
	{
		$raffle_id = $this->_input->filterSingle('raffle_id', XenForo_Input::UINT);
		$raffle = $this->_getRaffleOrError($raffle_id);
		return $this->_getWinnerResponse($raffle);
	}

	protected function _getWinnerResponse($raffle)
	{
		$viewParams = array(
				"raffle" => $raffle
		);
		return $this->responseView('Snog_Raffles_ViewAdmin_Raffle_Winner', 'raffles_winner_list', $viewParams);
	}

	protected function _getRaffleOrError($raffle_id)
	{
		$info = $this->_getRaffleModel()->getRaffle($raffle_id);
		if (!$info) throw $this->responseException($this->responseError(new XenForo_Phrase('raffles_raffle_notfound'), 404));
		return $info;
	}

	protected function _getRaffleModel()
	{
		return $this->getModelFromCache('Snog_Raffles_Model_Raffle');
	}

	protected function _getRafflesEntriesModel()
	{
		return $this->getModelFromCache('Snog_Raffles_Model_Entries');
	}

	protected function _getUserGroupModel()
	{
		return $this->getModelFromCache('XenForo_Model_UserGroup');
	}

	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	}
}