<?php
/*======================================================================*\
|| #################################################################### ||
|| # Country Flags for XenForo                                        # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Snog. All Rights Reserved.                      # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| #                     http://snogssite.com                         # ||
|| #################################################################### ||
\*======================================================================*/

abstract class Snog_CountryFlags_Option_ForumChooser
{
	public static function renderMultiple(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
	{
		$value = $preparedOption['option_value'];
		$editLink = $view->createTemplateObject('option_list_option_editlink', array('preparedOption' => $preparedOption, 'canEditOptionDefinition' => $canEdit));
		$nodeModel = XenForo_Model::create('XenForo_Model_Node');
		$options = $nodeModel->getNodeOptionsArray($nodeModel->getAllNodes(), false, false);

		foreach ($options AS &$option)
		{
			if (!empty($option['node_type_id']) && $option['node_type_id'] != 'Forum') $option['disabled'] = 'disabled';
			unset($option['node_type_id']);
		}

		return $view->createTemplateObject('snog_countryflags_option_list_option_multiple', array(
			'fieldPrefix' => $fieldPrefix,
			'listedFieldName' => $fieldPrefix . '_listed[]',
			'preparedOption' => $preparedOption,
			'formatParams' => $options,
			'editLink' => $editLink
		));
	}
}  