<?php
/*======================================================================*\
|| #################################################################### ||
|| # Country Flags for XenForo                                        # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Snog. All Rights Reserved.                      # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| #                     http://snogssite.com                         # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_CountryFlags_Model_Session extends XFCP_Snog_CountryFlags_Model_Session
{
	public function prepareSessionActivityFetchOptions(array $fetchOptions)
	{
		$userFetchOptions = parent::prepareSessionActivityFetchOptions($fetchOptions);

		// JOIN USER PRIVACY TABLE
		$userFetchOptions['selectFields'] .= ',privacy.snog_flag_view as snog_flag_view';

		$userFetchOptions['joinTables'] .= '
			LEFT JOIN xf_user_privacy AS privacy ON
			(privacy.user_id = session_activity.user_id)';

		return $userFetchOptions;
	}
}