<?php
/*======================================================================*\
 || #################################################################### ||
 || # Country Flags for XenForo                                        # ||
 || # ---------------------------------------------------------------- # ||
 || # Copyright � 2015 Snog. All Rights Reserved.                      # ||
 || # This file may not be redistributed in whole or significant part. # ||
 || # ---------------------------------------------------------------- # ||
 || #                     http://snogssite.com                         # ||
 || #################################################################### ||
 \*======================================================================*/

class Snog_CountryFlags_Model_Post extends XFCP_Snog_CountryFlags_Model_Post
{
	public function preparePostJoinOptions(array $fetchOptions)
	{
		$userOptions = parent::preparePostJoinOptions($fetchOptions);
		if(!empty($fetchOptions))
		{
			$userOptions['selectFields'] .= ',
					user_privacy.*';

			$userOptions['joinTables'] .= '
						LEFT JOIN xf_user_privacy AS user_privacy ON
							(user_privacy.user_id = post.user_id)';
		}

		return $userOptions;
	}
}