<?php
/*======================================================================*\
|| #################################################################### ||
|| # Country Flags for XenForo                                        # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2015 Snog. All Rights Reserved.                      # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| #                     http://snogssite.com                         # ||
|| #################################################################### ||
\*======================================================================*/

class Snog_CountryFlags_Model_Phrase extends XFCP_Snog_CountryFlags_Model_Phrase
{
	public function getEffectivePhrasesInLanguageByTitles(array $titles, $languageId = 0)
	{
		if (!$titles) return array();

		return $this->fetchAllKeyed('
			SELECT phrase_map.phrase_map_id,
				phrase_map.language_id AS map_language_id,
				phrase.*
			FROM xf_phrase_map AS phrase_map
			INNER JOIN xf_phrase AS phrase ON
				(phrase.phrase_id = phrase_map.phrase_id)
			WHERE phrase_map.title IN (' . $this->_getDb()->quote($titles) . ') AND phrase_map.language_id = ?
		', 'title', $languageId);
	}
}